#!/bin/sh

JAXE_DIR="/usr/local/src/jaxe"
JAXE_SCR_DIR=$JAXE_DIR"/scripts/contacts"
PLUGINS_CONTACTS_DIR=$JAXE_DIR"/plugins/source/contacts/InsertionAbreviations"
SED_SCRIPT=$JAXE_SCR_DIR"/Insere_Abrev_et_Langues.sed"
FICH_CONFIG_BASE=$JAXE_DIR"/config/CORPUS_config_base.xml"
FICH_CONFIG_ABRV=$JAXE_DIR"/config/CORPUS_config_abreviations.xml"
FICH_CONFIG_LST_LANG=$JAXE_DIR"/config/CORPUS_config_lst_lang.xml"
FICH_CONFIG_TIT_LANG=$JAXE_DIR"/config/CORPUS_config_tit_lang.xml"
FICH_CONFIG_LST_PDD=$JAXE_DIR"/config/CORPUS_config_lst_pdd.xml"
FICH_CONFIG_TIT_PDD=$JAXE_DIR"/config/CORPUS_config_tit_pdd.xml"
FICH_CONFIG=$JAXE_DIR"/config/CORPUS_config.xml"

# Gnration du fichier contenant le menu des abrviations

if ( test -f $FICH_CONFIG_ABRV )
then
    rm $FICH_CONFIG_ABRV
fi

echo "<MENU nom=\"Abréviations\">" > $FICH_CONFIG_ABRV

if ( test -f /tmp/abreviations.lst )
then
    rm /tmp/abreviations.lst
fi
cat $JAXE_DIR"/ABREVIATIONS.txt" | $JAXE_SCR_DIR/decommente | grep  > /tmp/abreviations.lst

if ( test -f /tmp/types.lst )
then
    rm /tmp/types.lst
fi
cat /tmp/abreviations.lst | gawk -F '{print $2}' | uniq > /tmp/types.lst

nb_types=`cat /tmp/types.lst | wc -l`

nb_abreviations=`cat /tmp/abreviations.lst | wc -l`

for (( num_type=1 ; $num_type <= ${nb_types} ; num_type = num_type + 1 ))
do
    nom_type=`cat /tmp/types.lst | sed -n ${num_type}','${num_type}'p'`
    nom_type_utf8=`echo ${nom_type} | $JAXE_SCR_DIR/lat1utf8`
    echo "<MENU nom=\"${nom_type_utf8}\">" >> $FICH_CONFIG_ABRV
    if ( test -f /tmp/sous-types-${num_type}.lst )
    then
	rm /tmp/sous-types-${num_type}.lst
    fi
    
    cat /tmp/abreviations.lst | gawk -F -v VNT="${nom_type}" '$2 == VNT {print $3}' | uniq | $JAXE_SCR_DIR/enleve-lignes-vides | uniq > /tmp/sous-types-${num_type}.lst

    nb_sous_types=`cat /tmp/sous-types-${num_type}.lst | wc -l`

    if [[ ${nb_sous_types} == 0 ]]
    then
	if ( test -f /tmp/attributs-${num_type}-0.lst )
	then
	    rm /tmp/attributs-${num_type}-0.lst
	fi
	cat /tmp/abreviations.lst | gawk -F -v VNT="${nom_type}" '$2 == VNT {print $4}' | uniq | $JAXE_SCR_DIR/enleve-lignes-vides | uniq > /tmp/attributs-${num_type}-0.lst
	nb_attributs=`cat /tmp/attributs-${num_type}-0.lst | wc -l`
	for (( num_attribut=1 ; $num_attribut <= ${nb_attributs} ; num_attribut = num_attribut + 1 ))
	do
	    nom_attribut=`cat /tmp/attributs-${num_type}-0.lst | sed -n ${num_attribut}','${num_attribut}'p'`
            nom_attribut_utf8=`echo ${nom_attribut} | $JAXE_SCR_DIR/lat1utf8`
	    echo "<MENU nom=\"${nom_attribut_utf8}\">" >> $FICH_CONFIG_ABRV
	    cat /tmp/abreviations.lst | gawk -F -v VNT="${nom_type}" -v VNA="${nom_attribut}" '(($2 == VNT)&&($4 == VNA)) {print $1""$6""$5}' | uniq | $JAXE_SCR_DIR/enleve-lignes-vides | uniq > /tmp/valeurs-${num_type}-0-${num_attribut}.lst
	    nb_valeurs=`cat /tmp/valeurs-${num_type}-0-${num_attribut}.lst | wc -l`
	    for (( num_valeur=1 ; $num_valeur <= ${nb_valeurs} ; num_valeur = num_valeur + 1 ))
	    do
		abreviation_ascii=`cat /tmp/valeurs-${num_type}-0-${num_attribut}.lst | sed -n ${num_valeur}','${num_valeur}'p' | gawk -F '{print $1}'`
		abreviation=`cat /tmp/valeurs-${num_type}-0-${num_attribut}.lst | sed -n ${num_valeur}','${num_valeur}'p' | gawk -F '{print $2}'`
                abreviation_utf8=`echo ${abreviation} | $JAXE_SCR_DIR/lat1utf8`
		nom_valeur=`cat /tmp/valeurs-${num_type}-0-${num_attribut}.lst | sed -n ${num_valeur}','${num_valeur}'p' | gawk -F '{print $3}'`
                nom_valeur_utf8=`echo ${nom_valeur} | $JAXE_SCR_DIR/lat1utf8`
		echo "<MENU_FONCTION classe=\"contacts.InsertionAbreviations.Insertion${abreviation_ascii}\" nom=\"${abreviation_utf8} (${nom_valeur_utf8})\"/>" >> $FICH_CONFIG_ABRV
	    done
	    echo "</MENU>" >> $FICH_CONFIG_ABRV
	    if ( test -f /tmp/valeurs-${num_type}-0-${num_attribut}.lst )
	    then
		rm /tmp/valeurs-${num_type}-0-${num_attribut}.lst
	    fi
	done
	if ( test -f /tmp/attributs-${num_type}-0.lst )
	then
	    rm /tmp/attributs-${num_type}-0.lst
	fi
    else
	for (( num_sous_type=1 ; $num_sous_type <= ${nb_sous_types} ; num_sous_type = num_sous_type + 1 ))
	do
	    nom_sous_type=`cat /tmp/sous-types-${num_type}.lst | sed -n ${num_sous_type}','${num_sous_type}'p'`
            nom_sous_type_utf8=`echo ${nom_sous_type} | $JAXE_SCR_DIR/lat1utf8`
	    echo "<MENU nom=\"${nom_sous_type_utf8}\">" >> $FICH_CONFIG_ABRV
	    if ( test -f /tmp/attributs-${num_type}-${num_sous_type}.lst )
	    then
		rm /tmp/attributs-${num_type}-${num_sous_type}.lst
	    fi
	    cat /tmp/abreviations.lst | gawk -F -v VNT="${nom_type}" -v VNST="${nom_sous_type}" '(($2 == VNT)&&($3 == VNST)) {print $4}' | uniq | $JAXE_SCR_DIR/enleve-lignes-vides | uniq > /tmp/attributs-${num_type}-${num_sous_type}.lst
	    nb_attributs=`cat /tmp/attributs-${num_type}-${num_sous_type}.lst | wc -l`
	    for (( num_attribut=1 ; $num_attribut <= ${nb_attributs} ; num_attribut = num_attribut + 1 ))
	    do
		nom_attribut=`cat /tmp/attributs-${num_type}-${num_sous_type}.lst | sed -n ${num_attribut}','${num_attribut}'p'`
                nom_attribut_utf8=`echo ${nom_attribut} | $JAXE_SCR_DIR/lat1utf8`
		echo "<MENU nom=\"${nom_attribut_utf8}\">" >> $FICH_CONFIG_ABRV
		cat /tmp/abreviations.lst | gawk -F -v VNT="${nom_type}" -v VNST="${nom_sous_type}" -v VNA="${nom_attribut}" '(($2 == VNT)&&($3 == VNST)&&($4 == VNA)) {print $1""$6""$5}' | uniq | $JAXE_SCR_DIR/enleve-lignes-vides | uniq > /tmp/valeurs-${num_type}-${num_sous_type}-${num_attribut}.lst
		nb_valeurs=`cat /tmp/valeurs-${num_type}-${num_sous_type}-${num_attribut}.lst | wc -l`
		for (( num_valeur=1 ; $num_valeur <= ${nb_valeurs} ; num_valeur = num_valeur + 1 ))
		do
		    abreviation_ascii=`cat /tmp/valeurs-${num_type}-${num_sous_type}-${num_attribut}.lst | sed -n ${num_valeur}','${num_valeur}'p' | gawk -F '{print $1}'`
		    abreviation=`cat /tmp/valeurs-${num_type}-${num_sous_type}-${num_attribut}.lst | sed -n ${num_valeur}','${num_valeur}'p' | gawk -F '{print $2}'`
                    abreviation_utf8=`echo ${abreviation} | $JAXE_SCR_DIR/lat1utf8`
		    nom_valeur=`cat /tmp/valeurs-${num_type}-${num_sous_type}-${num_attribut}.lst | sed -n ${num_valeur}','${num_valeur}'p' | gawk -F '{print $3}'`
                    nom_valeur_utf8=`echo ${nom_valeur} | $JAXE_SCR_DIR/lat1utf8`
		    echo "<MENU_FONCTION classe=\"contacts.InsertionAbreviations.Insertion${abreviation_ascii}\" nom=\"${abreviation_utf8} (${nom_valeur_utf8})\"/>" >> $FICH_CONFIG_ABRV
		done
		echo "</MENU>" >> $FICH_CONFIG_ABRV
		if ( test -f /tmp/valeurs-${num_type}-${num_sous_type}-${num_attribut}.lst )
		then
		    rm /tmp/valeurs-${num_type}-${num_sous_type}-${num_attribut}.lst
		fi
	    done
	    echo "</MENU>" >> $FICH_CONFIG_ABRV
	    if ( test -f /tmp/attributs-${num_type}-${num_sous_type}.lst )
	    then
		rm /tmp/attributs-${num_type}-${num_sous_type}.lst
	    fi
	done
    fi

    echo "</MENU>" >> $FICH_CONFIG_ABRV
    if ( test -f /tmp/sous-types-${num_type}.lst )
    then
	rm /tmp/sous-types-${num_type}.lst
    fi
done

echo "</MENU>" >> $FICH_CONFIG_ABRV

if ( test -f /tmp/types.lst )
then
    rm /tmp/types.lst
fi
if ( test -f /tmp/abreviations.lst )
then
    rm /tmp/abreviations.lst
fi

# Gnration des fichiers contenant la liste des valeurs suggres pour
# l'attribut LANG (pour les lments concerns)

if ( test -f $FICH_CONFIG_LST_LANG )
then
    rm $FICH_CONFIG_LST_LANG
fi

if ( test -f /tmp/langues.lst )
then
    rm /tmp/langues.lst
fi

cat $JAXE_DIR"/LANGUES.txt" | $JAXE_SCR_DIR/decommente | grep  > /tmp/langues.lst

touch $FICH_CONFIG_LST_LANG

cat /tmp/langues.lst | gawk -F '{print "<VALEUR_SUGGEREE>"$1"</VALEUR_SUGGEREE>"}' | sed -n '2,$p' | $JAXE_SCR_DIR/lat1utf8 >> $FICH_CONFIG_LST_LANG

# Gnration des fichiers contenant la liste des noms de langues
# correspondant aux diffrentes valeurs suggres pour l'attribut
# LANG (pour les lments concerns)

if ( test -f $FICH_CONFIG_TIT_LANG )
then
    rm $FICH_CONFIG_TIT_LANG
fi

touch $FICH_CONFIG_TIT_LANG

cat /tmp/langues.lst | sed 's/>/\&gt;/g' | gawk -F '{print "<TITRE_VALEUR valeur=\""$1"\">"$2$3"</TITRE_VALEUR>"}' | sed -n '2,$p' | $JAXE_SCR_DIR/lat1utf8 >> $FICH_CONFIG_TIT_LANG

if ( test -f /tmp/langues.lst )
then
    rm /tmp/langues.lst
fi

# Gnration des fichiers contenant la liste des parties du discours possibles

if ( test -f $FICH_CONFIG_LST_PDD )
then
    rm $FICH_CONFIG_LST_PDD
fi

if ( test -f /tmp/pdd.lst )
then
    rm /tmp/pdd.lst
fi

cat $JAXE_DIR"/PDD.txt" | $JAXE_SCR_DIR/decommente | grep  > /tmp/pdd.lst

touch $FICH_CONFIG_LST_PDD

cat /tmp/pdd.lst | gawk -F '{print "<VALEUR_SUGGEREE>"$1"</VALEUR_SUGGEREE>"}' | sed -n '2,$p' | $JAXE_SCR_DIR/lat1utf8 >> $FICH_CONFIG_LST_PDD

# Gnration des fichiers contenant la liste des noms de parties du
# discours correspondant aux diffrentes valeurs suggres pour l'attribut
# CAT (pour les parties du discours concernes)

if ( test -f $FICH_CONFIG_TIT_PDD )
then
    rm $FICH_CONFIG_TIT_PDD
fi

touch $FICH_CONFIG_TIT_PDD

cat /tmp/pdd.lst | gawk -F '{print "<TITRE_VALEUR valeur=\""$1"\">"$3"</TITRE_VALEUR>"}' | sed -n '2,$p' | $JAXE_SCR_DIR/lat1utf8 >> $FICH_CONFIG_TIT_PDD

if ( test -f /tmp/pdd.lst )
then
    rm /tmp/pdd.lst
fi

# Gnration du script sed qui va servir  faire les insertions dans le
# fichier de config

if ( test -f $SED_SCRIPT )
then
    rm $SED_SCRIPT
fi

if ( test -f /tmp/ligne_a_remettre_apres.txt )
then
    rm /tmp/ligne_a_remettre_apres.txt
fi

echo '\@<MENU nom="Informations">@ {' > $SED_SCRIPT
echo ' w /tmp/ligne_a_remettre_apres.txt' >> $SED_SCRIPT
echo -n ' r ' >> $SED_SCRIPT
echo $FICH_CONFIG_ABRV >> $SED_SCRIPT
echo ' r /tmp/ligne_a_remettre_apres.txt' >> $SED_SCRIPT
echo ' d' >> $SED_SCRIPT
echo '}' >> $SED_SCRIPT
echo '' >> $SED_SCRIPT
echo '\@<VALEUR_SUGGEREE>und</VALEUR_SUGGEREE>@ {' >> $SED_SCRIPT
echo -n ' r ' >> $SED_SCRIPT
echo $FICH_CONFIG_LST_LANG >> $SED_SCRIPT
echo ' d' >> $SED_SCRIPT
echo '}' >> $SED_SCRIPT
echo '\@<VALEUR_SUGGEREE>mul</VALEUR_SUGGEREE>@ {' >> $SED_SCRIPT
echo -n ' r ' >> $SED_SCRIPT
echo $FICH_CONFIG_LST_LANG >> $SED_SCRIPT
echo '}' >> $SED_SCRIPT
echo '\@<TITRE_VALEUR valeur="und">indéterminé</TITRE_VALEUR>@ {' >> $SED_SCRIPT
echo -n ' r ' >> $SED_SCRIPT
echo $FICH_CONFIG_TIT_LANG >> $SED_SCRIPT
echo ' d' >> $SED_SCRIPT
echo '}' >> $SED_SCRIPT
echo '\@<TITRE_VALEUR valeur="mul">plusieurs langues</TITRE_VALEUR>@ {' >> $SED_SCRIPT
echo -n ' r ' >> $SED_SCRIPT
echo $FICH_CONFIG_TIT_LANG >> $SED_SCRIPT
echo '}' >> $SED_SCRIPT
echo '\@<TITRE_VALEUR valeur="mul">plusieurs langues possibles</TITRE_VALEUR>@ {' >> $SED_SCRIPT
echo -n ' r ' >> $SED_SCRIPT
echo $FICH_CONFIG_TIT_LANG >> $SED_SCRIPT
echo '}' >> $SED_SCRIPT
echo '\@<VALEUR_SUGGEREE>N</VALEUR_SUGGEREE>@ {' >> $SED_SCRIPT
echo -n ' r ' >> $SED_SCRIPT
echo $FICH_CONFIG_LST_PDD >> $SED_SCRIPT
echo '}' >> $SED_SCRIPT
echo '\@<TITRE_VALEUR valeur="N">groupe nominal</TITRE_VALEUR>@ {' >> $SED_SCRIPT
echo -n ' r ' >> $SED_SCRIPT
echo $FICH_CONFIG_TIT_PDD >> $SED_SCRIPT
echo '}' >> $SED_SCRIPT

if ( test -f /tmp/ligne_a_remettre_apres.txt )
then
    rm /tmp/ligne_a_remettre_apres.txt
fi

# On insre ces fichiers temporaires (liste d'abrviations, listes de
# langues ...) aux endroits o il faut dans le fichier de config de base,
# pour donner le fichier config complet.
# N.B. Ce travail est fait par le script sed Insere_Abrev_et_Langues.sed

cat $FICH_CONFIG_BASE | sed -f $SED_SCRIPT > $FICH_CONFIG

# Si la procdure n'a pas march, pour une raison ou une autre,
# on recopie juste le fichier de config de base (qui doit tre
# syntaxiquement correct  dfaut d'tre complet)

if (!( test -f $FICH_CONFIG ))
then
    cp $FICH_CONFIG_BASE $FICH_CONFIG
fi

# Et on supprime les machins dont on n'a plus besoin

if ( test -f $FICH_CONFIG_ABRV )
then
    rm $FICH_CONFIG_ABRV
fi

if ( test -f $FICH_CONFIG_LST_LANG )
then
    rm $FICH_CONFIG_LST_LANG
fi

if ( test -f $FICH_CONFIG_TIT_LANG )
then
    rm $FICH_CONFIG_TIT_LANG
fi

if ( test -f $FICH_CONFIG_LST_PDD )
then
    rm $FICH_CONFIG_LST_PDD
fi

if ( test -f $FICH_CONFIG_TIT_PDD )
then
    rm $FICH_CONFIG_TIT_PDD
fi

