#!/bin/sh

JAXE_DIR="/usr/local/src/jaxe"
JAXE_SCR_DIR=$JAXE_DIR"/scripts/contacts"
PLUGINS_CONTACTS_DIR=$JAXE_DIR"/plugins/source/contacts/InsertionAbreviations"

if ( test -f /tmp/abreviations.lst )
then
    rm /tmp/abreviations.lst
fi
cat $JAXE_DIR"/ABREVIATIONS.txt" | $JAXE_SCR_DIR/decommente | grep  > /tmp/abreviations.lst

nb_abreviations=`cat /tmp/abreviations.lst | wc -l`

for (( ln=1 ; $ln <= ${nb_abreviations} ; ln = ln + 1 ))
do
    abreviation=`cat /tmp/abreviations.lst | sed -n ${ln}','${ln}'p' | awk -F '{print $6}' | $JAXE_SCR_DIR/lat1utf8`
    nom_en_lettres=`cat /tmp/abreviations.lst | sed -n ${ln}','${ln}'p' | awk -F '{print $1}'`
    terme_francais=`cat /tmp/abreviations.lst | sed -n ${ln}','${ln}'p' | awk -F '{print $5}' | $JAXE_SCR_DIR/lat1utf8`
    terme_anglais=`cat /tmp/abreviations.lst | sed -n ${ln}','${ln}'p' | awk -F '{print $7}' | $JAXE_SCR_DIR/lat1utf8`
    commentaire=`cat /tmp/abreviations.lst | sed -n ${ln}','${ln}'p' | awk -F '{print $9}' | $JAXE_SCR_DIR/lat1utf8`
    nom_fichier=${PLUGINS_CONTACTS_DIR}"/Insertion"${nom_en_lettres}".java"
    if ( test -f ${nom_fichier} )
    then
	rm ${nom_fichier}
    fi
    echo -n "Cration de ${nom_fichier} "
    echo -n "("${ln}"/"${nb_abreviations}")"
    echo -n " ... "
    if [[ ${abreviation} == "\\" ]]
    then
	cat ${PLUGINS_CONTACTS_DIR}"/InsertionNomAbreviationASCII.java" | sed 's/CetteAbreviation/\\\\/g' > ${nom_fichier}".1"
    else
	cat ${PLUGINS_CONTACTS_DIR}"/InsertionNomAbreviationASCII.java" | sed 's/CetteAbreviation/'${abreviation}'/g' > ${nom_fichier}".1"
    fi
    cat ${nom_fichier}".1" | sed "s#NomAbreviationASCII#${nom_en_lettres}#g" > ${nom_fichier}".2"
    rm ${nom_fichier}".1"
    cat ${nom_fichier}".2" | sed "s#TermeFrancais#${terme_francais}#g" > ${nom_fichier}".3"
    rm ${nom_fichier}".2"
    cat ${nom_fichier}".3" | sed "s#TermeAnglais#${terme_anglais}#g" > ${nom_fichier}".4"
    rm ${nom_fichier}".3"
    cat ${nom_fichier}".4" | sed "s#[\x2A][\x2A][\x2A]#${commentaire}#g" > ${nom_fichier}
    rm ${nom_fichier}".4"
    echo "ok."
done

