<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" extension-element-prefixes="xalanredirect exsl" xmlns:xalanredirect="http://xml.apache.org/xalan/redirect" xmlns:exsl="http://exslt.org/common">
    
    <xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd" encoding="UTF-8"/>
    
    <xsl:param name="jaxe-fichier-xml"/>
    <xsl:param name="jaxe-fichier-xsl"/>
    <xsl:param name="jaxe-uri-xml"/>
    <xsl:param name="affichage">web</xsl:param> <!-- web / impression -->
    
    <!-- sparateur de chemins ( / ou \ ) -->
    <xsl:variable name="sep"><xsl:choose>
        <xsl:when test="contains($jaxe-fichier-xml, '\')">\</xsl:when>
        <xsl:otherwise>/</xsl:otherwise>
    </xsl:choose></xsl:variable>
    
    <!-- chemin du rpertoire du fichier XML -->
    <xsl:variable name="chemin-xml"><xsl:call-template name="rep-fichier"><xsl:with-param name="chemin" select="$jaxe-fichier-xml"/></xsl:call-template></xsl:variable>
    <xsl:variable name="uri-chemin-xml"><xsl:call-template name="rep-uri"><xsl:with-param name="chemin" select="$jaxe-uri-xml"/></xsl:call-template></xsl:variable>
    
    <!-- chemin du rpertoire du fichier XSL -->
    <xsl:variable name="chemin-xsl"><xsl:call-template name="rep-fichier"><xsl:with-param name="chemin" select="$jaxe-fichier-xsl"/></xsl:call-template></xsl:variable>
    
    <!-- chemin du rpertoire dans lequel les fichiers HTML seront gnrs -->
    <xsl:param name="chemin-site"><xsl:value-of select="concat($chemin-xml, $sep, 'site')"/></xsl:param>
    <xsl:param name="uri-site"><xsl:value-of select="concat($uri-chemin-xml, '/site')"/></xsl:param>
    
    <!-- chemin du rpertoire contribXML (dans lequel se trouvent toutes les contributions) -->
    <xsl:variable name="chemin-contrib"><xsl:call-template name="rep-fichier"><xsl:with-param name="chemin" select="$chemin-xml"/></xsl:call-template></xsl:variable>
    
    <xsl:variable name="feuille-de-style"><xsl:choose>
        <xsl:when test="$affichage='web'">style.css</xsl:when>
        <xsl:otherwise>style_impression.css</xsl:otherwise>  <!--  faire -->
    </xsl:choose></xsl:variable>
    
    <xsl:variable name="interface_par_defaut">peinture</xsl:variable>
    
    <!-- langue du document -->
    <xsl:variable name="langue"><xsl:choose>
        <xsl:when test="/XPAGES/INFORMATIONS/LANGUE"><xsl:value-of select="/XPAGES/INFORMATIONS/LANGUE"/></xsl:when>
        <xsl:otherwise>fr</xsl:otherwise>
    </xsl:choose></xsl:variable>
    <!-- document avec les messages dans la langue de l'ensemble -->
    <xsl:variable name="messages" select="document(concat($chemin-xsl, '/XPAGES_messages_', $langue, '.xml'))/messages"/>
    
    
        
    <xsl:template match="/">
        
        <!-- nom du fichier XML (qui doit tre gal au label de l'ensemble) -->
        <xsl:variable name="nomfichierxml"><xsl:call-template name="nom-fichier">
            <xsl:with-param name="chemin" select="$jaxe-fichier-xml"/>
        </xsl:call-template></xsl:variable>
        
        <!-- nom du rpertoire du fichier XML (qui doit tre gal au label de l'ensemble) -->
        <xsl:variable name="nomrep"><xsl:call-template name="nom-fichier"><xsl:with-param name="chemin" select="$chemin-xml"/></xsl:call-template></xsl:variable>
        
        <html>
        <head>
            <title><xsl:value-of select="$messages/message[@label='Aperu']"/></title>
        </head>
        <body>
        
        <xsl:call-template name="infos-erreurs"/>
        
        <!-- fichier site/index.html -->
        <xsl:for-each select="/XPAGES">
            <xsl:choose>
                <xsl:when test="count(PAGE[@label='index']) &gt; 0">
                    <xsl:for-each select="PAGE[@label='index']">
                        <xsl:call-template name="ecrire-fichier">
                            <xsl:with-param name="fichier" select="concat($chemin-site, $sep, 'index.html')"/>
                            <xsl:with-param name="contenu">
                                <xsl:call-template name="page-entree"/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="ecrire-fichier">
                        <xsl:with-param name="fichier" select="concat($chemin-site, $sep, 'index.html')"/>
                        <xsl:with-param name="contenu">
                            <xsl:call-template name="page-entree"/>
                        </xsl:with-param>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
        
        <xsl:if test="$nomrep = XPAGES/INFORMATIONS/LABEL and $nomfichierxml = concat($nomrep, '.xml')">
            
            <xsl:apply-templates/>
            
            <xsl:choose>
                <xsl:when test="$affichage='web'">
                    <p><a href="site/index.html"><xsl:value-of select="$messages/message[@label='aller  la page d_accueil du site']"/></a></p>
                    <p><a href="site/pages_{XPAGES/INFORMATIONS/LABEL}/sommaire.html"><xsl:value-of select="$messages/message[@label='aller au sommaire']"/></a></p>
                </xsl:when>
                <xsl:otherwise>
                    <p><a href="site/pages_{XPAGES/INFORMATIONS/LABEL}/impression.html"><xsl:value-of select="$messages/message[@label='aller  la page d_impression']"/></a></p>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        
        </body>
        </html>
    </xsl:template>
    
    
    <xsl:template name="infos-erreurs">
        <!-- nom du fichier XML (qui doit tre gal au label de l'ensemble) -->
        <xsl:variable name="nomfichierxml"><xsl:call-template name="nom-fichier">
            <xsl:with-param name="chemin" select="$jaxe-fichier-xml"/>
        </xsl:call-template></xsl:variable>
        
        <!-- nom du rpertoire du fichier XML (qui doit tre gal au label de l'ensemble) -->
        <xsl:variable name="nomrep"><xsl:call-template name="nom-fichier"><xsl:with-param name="chemin" select="$chemin-xml"/></xsl:call-template></xsl:variable>
        
        <xsl:choose>
            <xsl:when test="count(/XPAGES/INFORMATIONS) = 0">
                <p><b><xsl:value-of select="$messages/message[@label='Attention !']"/></b>&#xA0;<xsl:value-of select="$messages/message[@label='L_lment INFORMATIONS est obligatoire sous la racine XPAGE. C_est un lment  insrer en premier dans le document, et qui permet de spcifier son label et son titre.']"/></p>
            </xsl:when>
            
            <xsl:when test="count(/XPAGES/INFORMATIONS/LABEL) = 0">
                <p><b><xsl:value-of select="$messages/message[@label='Attention !']"/></b>&#xA0;<xsl:value-of select="$messages/message[@label='Le label est obligatoire dans les informations. Il permet d_identifier le document, et de faire des liens vers ce document depuis d_autres documents XPAGES. Ce label doit correspondre au nom du fichier XML et au nom du dossier parent.']"/></p>
            </xsl:when>
            
            <xsl:when test="$nomrep != /XPAGES/INFORMATIONS/LABEL or $nomfichierxml != concat($nomrep, '.xml')">
                <p><b><xsl:value-of select="$messages/message[@label='Attention !']"/></b>&#xA0;<xsl:value-of select="$messages/message[@label='Le nom du dossier doit tre gal au label du document, et le nom du fichier XML doit tre le label avec l_extension .xml.']"/></p>
                <p><xsl:value-of select="$messages/message[@label='Actuellement, le nom du dossier est']"/>&#xA0;<tt><xsl:value-of select="$nomrep"/></tt><xsl:value-of select="$messages/message[@label=', le label du document est']"/>&#xA0;<tt><xsl:value-of select="/XPAGES/INFORMATIONS/LABEL"/></tt><xsl:value-of select="$messages/message[@label=', et le nom du fichier est']"/>&#xA0;<tt><xsl:value-of select="$nomfichierxml"/></tt></p>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    
    <xsl:template match="XPAGES">
        
        <xsl:variable name="prefixe">../</xsl:variable>
        <xsl:variable name="interface"><xsl:value-of select="$prefixe"/>interface/<xsl:choose>
            <xsl:when test="count(ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!='']) &gt; 0"><xsl:value-of select="ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!=''][1]/INFORMATIONS/INTERFACE"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$interface_par_defaut"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        
        <xsl:choose>
            <xsl:when test="$affichage='web'">
                
                <xsl:call-template name="ecrire-fichier">
                    <xsl:with-param name="fichier" select="concat($chemin-site, $sep, 'pages_', INFORMATIONS/LABEL, $sep, 'index.html')"/>
                    <xsl:with-param name="contenu">
                        <xsl:call-template name="page-index">
                            <xsl:with-param name="interface"><xsl:value-of select="$interface"/></xsl:with-param>
                        </xsl:call-template>
                    </xsl:with-param>
                </xsl:call-template>
                
                <xsl:apply-templates select="PAGE[@label!='index']|XPAGES"/>
                
                <xsl:call-template name="ecrire-fichier">
                    <xsl:with-param name="fichier" select="concat($chemin-site, $sep, 'pages_', INFORMATIONS/LABEL, $sep, 'sommaire.html')"/>
                    <xsl:with-param name="contenu">
                        <xsl:call-template name="page-sommaire"/>
                    </xsl:with-param>
                </xsl:call-template>
                
                <xsl:if test="//GLOSSAIRE">
                    <xsl:call-template name="ecrire-fichier">
                        <xsl:with-param name="fichier" select="concat($chemin-site, $sep, 'pages_', INFORMATIONS/LABEL, $sep, 'glossaire.html')"/>
                        <xsl:with-param name="contenu">
                            <xsl:call-template name="page-glossaire"/>
                        </xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
                
                <xsl:if test="count(ancestor::XPAGES)=0">
                    <xsl:for-each select="//ENVIMAGE/FICHIER[1]">
                        <xsl:variable name="label-ensemble" select="ancestor::XPAGES[1]/INFORMATIONS/LABEL"/>
                        <xsl:variable name="nomfichier" select="@nom"/>
                        <xsl:variable name="localisation" select="../@localisation"/>
                        <xsl:variable name="largeur1" select="document(concat($uri-site, '/images.xml'))/IMAGES/IMAGE[@contrib=$label-ensemble and @nom=$nomfichier and @localisation=$localisation]/@largeur1"/>
                        <xsl:variable name="hauteur1" select="document(concat($uri-site, '/images.xml'))/IMAGES/IMAGE[@contrib=$label-ensemble and @nom=$nomfichier and @localisation=$localisation]/@hauteur1"/>
                        <xsl:variable name="redim" select="document(concat($uri-site, '/images.xml'))/IMAGES/IMAGE[@contrib=$label-ensemble and @nom=$nomfichier and @localisation=$localisation]/@redim"/>
                        <xsl:if test="($redim='oui' or $localisation='icne') and count(preceding::FICHIER[@nom=$nomfichier and ancestor::XPAGES[1]/INFORMATIONS/LABEL=$label-ensemble])=0">
                        <!-- les vidos ne peuvent pas tre redimensionnes mais il faut un fichier HTML si elles sont en icne -->
                            <xsl:call-template name="html-figure">
                                <xsl:with-param name="largeur1" select="$largeur1"/>
                                <xsl:with-param name="hauteur1" select="$hauteur1"/>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:if>
            </xsl:when>
            
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="count(ancestor::XPAGES)=0">
                        <xsl:call-template name="ecrire-fichier">
                            <xsl:with-param name="fichier" select="concat($chemin-site, $sep, 'pages_', INFORMATIONS/LABEL, $sep, 'impression.html')"/>
                            <xsl:with-param name="contenu">
                                <html>
                                <head>
                                    <title><xsl:value-of select="$messages/message[@label='Page pour l_impression']"/></title>
                                    <link type="text/css" rel="stylesheet" href="{$interface}/{$feuille-de-style}"/>
                                </head>
                                <body>
                                    <xsl:apply-templates select="PAGE|XPAGES"/>
                                </body>
                                </html>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="PAGE|XPAGES"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    
    <xsl:template name="zone_bandeau">
        <xsl:variable name="nb" select="count(ancestor-or-self::XPAGES)"/>
        <div class="titre_site_1"><xsl:value-of select="ancestor-or-self::XPAGES[$nb]/INFORMATIONS/TITRE"/></div>
        <div class="titre_site_2"><xsl:value-of select="ancestor-or-self::XPAGES[$nb]/INFORMATIONS/TITRE"/></div>
    </xsl:template>
    
    
    <xsl:template name="zone_rubriques">
        <xsl:param name="prefixe">../</xsl:param>
        <div class="zone_rubriques">
        <table class="table_rubriques" cellspacing="5"><tr>
            <xsl:variable name="labelsel" select="ancestor-or-self::XPAGES[last()-1]/INFORMATIONS/LABEL"/>
            <xsl:for-each select="ancestor-or-self::XPAGES[last()]/XPAGES">
                <xsl:choose>
                    <xsl:when test="INFORMATIONS/LABEL=$labelsel">
                        <td class="rubriquesel">
                            <xsl:value-of select="INFORMATIONS/TITRE"/>
                        </td>
                    </xsl:when>
                    <xsl:otherwise>
                        <td class="rubrique">
                            <a href="{$prefixe}pages_{INFORMATIONS/LABEL}/{PAGE[1]/@label}.html"><xsl:value-of select="INFORMATIONS/TITRE"/></a>
                        </td>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </tr></table>
        </div>
    </xsl:template>
    
    
    <xsl:template name="page-index">
        <xsl:param name="interface"/>
        
        <xsl:variable name="prefixe">../</xsl:variable>
        <html>
        <head>
            <xsl:if test="INFORMATIONS/TITRE!=''">
                <title><xsl:value-of select="INFORMATIONS/TITRE"/></title>
            </xsl:if>
            <link type="text/css" rel="stylesheet" href="{$interface}/{$feuille-de-style}"/>
            <xsl:for-each select="preceding::PAGE[1]">
                <link rel="Prev"  href="{$prefixe}pages_{../INFORMATIONS/LABEL}/{@label}.html"/>
            </xsl:for-each>
            <xsl:variable name="nb" select="count(ancestor-or-self::XPAGES)"/>
            <link rel="Contents"  href="{$prefixe}pages_{ancestor-or-self::XPAGES[$nb]/INFORMATIONS/LABEL}/sommaire.html"/>
            <link rel="Start"  href="{PAGE[1]/@label}.html"/>
            <xsl:for-each select="PAGE[1]">
                <link rel="Next"  href="{$prefixe}pages_{../INFORMATIONS/LABEL}/{@label}.html"/>
            </xsl:for-each>
            <xsl:choose>
                <xsl:when test="count(ancestor::XPAGES) &gt; 1">
                    <link rel="Up" href="{$prefixe}pages_{ancestor::XPAGES[1]/INFORMATIONS/LABEL}/index.html"/>
                </xsl:when>
                <xsl:otherwise>
                    <link rel="Up" href="{$prefixe}index.html"/>
                </xsl:otherwise>
            </xsl:choose>
        </head>
        <body class="page">
            <xsl:call-template name="contenu-body"/>
        </body>
        </html>
    </xsl:template>
    
    <xsl:template name="texte-index">
        <xsl:param name="prefixe">../</xsl:param>
        <!-- liste des pages de la contribution -->
        <ol>
            <xsl:for-each select="PAGE|XPAGES">
                <li>
                    <xsl:choose>
                        <xsl:when test="self::PAGE">
                            <a href="{@label}.html" class="lien"><xsl:choose>
                                <xsl:when test="@titre!=''"><xsl:value-of select="@titre"/></xsl:when>
                                <xsl:otherwise><xsl:value-of select="$messages/message[@label='page']"/> <xsl:value-of select="position()"/></xsl:otherwise>
                            </xsl:choose></a>
                        </xsl:when>
                        <xsl:when test="self::XPAGES">
                            <a href="{$prefixe}pages_{INFORMATIONS/LABEL}/{PAGE[1]/@label}.html" class="lien"><xsl:value-of select="INFORMATIONS/TITRE"/></a>
                        </xsl:when>
                    </xsl:choose>
                </li>
            </xsl:for-each>
        </ol>
    </xsl:template>
    
    
    <xsl:template match="PAGE">
        <xsl:choose>
            <xsl:when test="$affichage='web'">
                <xsl:call-template name="ecrire-fichier">
                    <xsl:with-param name="fichier" select="concat($chemin-site, $sep, 'pages_', ../INFORMATIONS/LABEL, $sep, @label,'.html')"/>
                    <xsl:with-param name="contenu">
                        <xsl:call-template name="contenu-page"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="contenu-body"/>
                <div style="page-break-after: always"/> <!-- pour les navigateurs comprenant CSS 2 -->
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <xsl:template name="contenu-page">
        <xsl:variable name="prefixe">../</xsl:variable>
        <xsl:variable name="interface"><xsl:value-of select="$prefixe"/>interface/<xsl:choose>
            <xsl:when test="count(ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!='']) &gt; 0"><xsl:value-of select="ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!=''][1]/INFORMATIONS/INTERFACE"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$interface_par_defaut"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <html>
        <head>
            <xsl:choose>
            <xsl:when test="@titre!=''">
                <title><xsl:value-of select="@titre"/></title>
            </xsl:when>
            <xsl:otherwise>
                <title>page <xsl:value-of select="position()"/></title>
            </xsl:otherwise>
            </xsl:choose>
            <link type="text/css" rel="stylesheet" href="{$interface}/{$feuille-de-style}"/>
            <xsl:for-each select="preceding::PAGE[1]">
                <link rel="Prev"  href="{$prefixe}pages_{../INFORMATIONS/LABEL}/{@label}.html"/>
            </xsl:for-each>
            <link rel="Contents"  href="index.html"/>
            <xsl:for-each select="following::PAGE[1]">
                <link rel="Next"  href="{$prefixe}pages_{../INFORMATIONS/LABEL}/{@label}.html"/>
            </xsl:for-each>
            <xsl:choose>
                <xsl:when test="count(ancestor::XPAGES) &gt; 1">
                    <link rel="Up" href="{$prefixe}pages_{ancestor::XPAGES[1]/INFORMATIONS/LABEL}/index.html"/>
                </xsl:when>
                <xsl:otherwise>
                    <link rel="Up" href="{$prefixe}index.html"/>
                </xsl:otherwise>
            </xsl:choose>
            <!-- ce meta est ajout automatiquement -->
            <!--<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>-->
        </head>
        <body class="page">
            <xsl:call-template name="contenu-body"/>
        </body>
        </html>
    </xsl:template>
    
    
    <xsl:template name="zone_logo">
        <xsl:param name="prefixe">../</xsl:param>
        <div class="zone_logo">
            <xsl:for-each select="ancestor-or-self::XPAGES/INFORMATIONS/LOGO[1]">
                <xsl:choose>
                    <xsl:when test="@lien!=''"><a href="{@lien}"><img src="{$prefixe}pages_{../LABEL}/{@fichier}" alt="{@fichier}" border="0"/></a></xsl:when>
                    <xsl:otherwise><img src="{$prefixe}pages_{../LABEL}/{@fichier}" alt="{@fichier}"/></xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </div>
    </xsl:template>
    
    
    <xsl:template name="contenu-body">

    <!--
    Organisation des divs:
    
         ______________________
        |    titre site   | lo |
        |_________________| go |
        |outils |  titre  |    |
        |       |_________|____|
        |       |              |
        |  som  |  corps du    |
        | maire |  texte       |
        |       |              |
        |       |              |
        |       |              |
        |_______|______________|
    
    -->
    
        <xsl:variable name="prefixe">../</xsl:variable>
        <xsl:variable name="interface"><xsl:value-of select="$prefixe"/>interface/<xsl:choose>
            <xsl:when test="count(ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!='']) &gt; 0"><xsl:value-of select="ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!=''][1]/INFORMATIONS/INTERFACE"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$interface_par_defaut"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        
        <xsl:call-template name="zone_logo"/>
        
        <xsl:call-template name="zone_bandeau"/>
        
        <xsl:if test="count(ancestor-or-self::XPAGES[last()]/XPAGES) &gt; 1">
            <xsl:call-template name="zone_rubriques"/>
        </xsl:if>
        
        <div class="zone_sommaire">
            <div class="zone_mininav">
                <table width="100%"><tr>
                    <xsl:variable name="nb" select="count(ancestor-or-self::XPAGES)"/>
                    <td align="center">
                        <a href="{$prefixe}index.html" title="{$messages/message[@label='entre du site']}"><img src="{$interface}/home.gif" width="25" height="25" alt="{$messages/message[@label='entre du site']}" border="0"/></a>
                    </td>
                    <td align="center">
                        <a href="{$prefixe}pages_{ancestor-or-self::XPAGES[$nb]/INFORMATIONS/LABEL}/sommaire.html" title="{$messages/message[@label='Sommaire']}"><img src="{$interface}/sommaire_petit.gif" width="25" height="25" border="0" alt="{$messages/message[@label='Sommaire']}"/></a>
                    </td>
                    <xsl:if test="//GLOSSAIRE">
                        <td align="center">
                            <a href="{$prefixe}pages_{ancestor-or-self::XPAGES[$nb]/INFORMATIONS/LABEL}/glossaire.html" title="{$messages/message[@label='Glossaire']}"><img src="{$interface}/glossaire_petit.gif" width="25" height="25" border="0" alt="{$messages/message[@label='Glossaire']}"/></a>
                        </td>
                    </xsl:if>
                    <td align="center">
                        <xsl:for-each select="preceding::PAGE[1][@label!='index']">
                            <a href="{$prefixe}pages_{../INFORMATIONS/LABEL}/{@label}.html" accesskey="j" title="{$messages/message[@label='Page prcdente']}"><img src="{$interface}/petiteflechegauche.gif" width="25" height="16" alt="&lt;-" border="0"/></a>
                        </xsl:for-each>
                    </td>
                
                    <td align="center">
                        <xsl:for-each select="PAGE[1] | following::PAGE[current()/self::PAGE and position()=1]">
                            <a href="{$prefixe}pages_{../INFORMATIONS/LABEL}/{@label}.html" accesskey="l" title="{$messages/message[@label='Page suivante']}"><img src="{$interface}/petiteflechedroite.gif" width="25" height="16" alt="-&gt;" border="0"/></a>
                        </xsl:for-each>
                    </td>
                </tr></table>
            </div>
            
            <xsl:call-template name="sommaire-page"/>
        </div>
        
        <div class="zone_titre">
            <xsl:variable name="titre"><xsl:choose>
                <xsl:when test="self::XPAGES"><xsl:value-of select="INFORMATIONS/TITRE"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="@titre"/></xsl:otherwise>
            </xsl:choose></xsl:variable>
            <table cellspacing="0" cellpadding="0"><tr>
            <td><h1><xsl:value-of select="$titre"/></h1></td>
            </tr></table>
        </div>
        
        <div class="zone_contenu">
            
            <xsl:if test="count(ancestor-or-self::XPAGES[1]/INFORMATIONS/AUTEUR) &gt; 0">
                <div class="auteurs">
                    <xsl:call-template name="auteurs"/>
                </div>
            </xsl:if>
            
            <xsl:choose>
                <xsl:when test="self::XPAGES">
                    <div class="zone_texte">
                        <xsl:call-template name="texte-index">
                            <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                        </xsl:call-template>
                    </div>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test=".//ENVIMAGE[@localisation='page']">
                        <xsl:call-template name="figures-page">
                            <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                    <div class="zone_texte">
                        <xsl:apply-templates/>
                    </div>
                </xsl:otherwise>
            </xsl:choose>
            
            <div class="spacer"></div>
            
            <div class="zone_liens">
                <table width="100%"><tr>
                    <td>
                        <xsl:for-each select="preceding::PAGE[1][@label!='index']">
                            <a href="{$prefixe}pages_{../INFORMATIONS/LABEL}/{@label}.html" title="{$messages/message[@label='Page prcdente']}"><img src="{$interface}/flechegauche.gif" width="48" height="31" alt="{$messages/message[@label='Page prcdente']}" border="0"/></a>
                        </xsl:for-each>
                    </td>
                    <td align="right">
                        <xsl:for-each select="PAGE[1] | following::PAGE[current()/self::PAGE and position()=1]">
                            <a href="{$prefixe}pages_{../INFORMATIONS/LABEL}/{@label}.html" title="{$messages/message[@label='Page suivante']}"><img src="{$interface}/flechedroite.gif" width="48" height="31" alt="{$messages/message[@label='Page suivante']}" border="0"/></a>
                        </xsl:for-each>
                    </td>
                </tr></table>
            </div>
        </div>
    </xsl:template>
    
    
    <!-- Sommaire -->
    
    <xsl:template name="sous-sommaire">
        <xsl:param name="pos"/>
        <xsl:param name="interface"/>
        
        <xsl:variable name="prefixe">../</xsl:variable>
        <xsl:choose>
            <xsl:when test="$pos &gt; 1 and $pos = count(ancestor-or-self::XPAGES)">
                <xsl:call-template name="sous-sommaire">
                    <xsl:with-param name="pos"><xsl:value-of select="$pos - 1"/></xsl:with-param>
                    <xsl:with-param name="interface"><xsl:value-of select="$interface"/></xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$pos &gt; 1">
                <img height="11" width="11" alt="-" border="0" src="{$interface}/listeactive.gif"/>
                <xsl:for-each select="ancestor-or-self::XPAGES[$pos]">
                    <a href="{$prefixe}pages_{INFORMATIONS/LABEL}/{PAGE[1]/@label}.html" class="sommaire2">&#xA0;<xsl:value-of select="INFORMATIONS/TITRE"/></a>
                </xsl:for-each>
                <div class="divsommaire">
                    <xsl:call-template name="sous-sommaire">
                        <xsl:with-param name="pos"><xsl:value-of select="$pos - 1"/></xsl:with-param>
                        <xsl:with-param name="interface"><xsl:value-of select="$interface"/></xsl:with-param>
                    </xsl:call-template>
                </div>
            </xsl:when>
            <xsl:when test="self::XPAGES">
                <div class="fondsel1sommaire">
                    <img height="11" width="11" alt="-" border="0" src="{$interface}/listeactive.gif"/>&#xA0;<span class="sommaire2select"><xsl:value-of select="INFORMATIONS/TITRE"/></span>
                    <div class="divsommaire">
                        <xsl:for-each select="PAGE|XPAGES">
                            <xsl:call-template name="element-sommaire">
                                <xsl:with-param name="interface"><xsl:value-of select="$interface"/></xsl:with-param>
                            </xsl:call-template>
                        </xsl:for-each>
                    </div>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="fondsel1sommaire">
                    <xsl:for-each select="ancestor::XPAGES[2]">
                        <a href="{$prefixe}pages_{INFORMATIONS/LABEL}/{PAGE[1]/@label}.html"><img height="11" width="11" alt="-" border="0" src="{$interface}/listeactive.gif"/></a>
                    </xsl:for-each>
                    <span class="sommaire2">&#xA0;<xsl:value-of select="../INFORMATIONS/TITRE"/></span>
                    <div class="divsommaire">
                        <xsl:variable name="labelpage" select="@label"/>
                        <xsl:for-each select="../*[self::PAGE or self::XPAGES]">
                            <xsl:call-template name="element-sommaire">
                                <xsl:with-param name="labelpage"><xsl:value-of select="$labelpage"/></xsl:with-param>
                                <xsl:with-param name="interface"><xsl:value-of select="$interface"/></xsl:with-param>
                            </xsl:call-template>
                        </xsl:for-each>
                    </div>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="element-sommaire">
        <xsl:param name="labelpage"/>
        <xsl:param name="interface"/>
        
        <xsl:variable name="prefixe">../</xsl:variable>
        <xsl:choose>
            <xsl:when test="self::PAGE and @label=$labelpage">
                <div class="fondsel2sommaire">
                    <span class="sommairepage">&#x2022; <xsl:value-of select="@titre"/></span>
                </div>
            </xsl:when>
            <xsl:when test="self::XPAGES">
                <div class="fondsel1sommaire"><img src="{$interface}/listeinactive.gif" border="0" alt="+" width="11" height="11"/>
                <a href="{$prefixe}pages_{INFORMATIONS/LABEL}/{PAGE[1]/@label}.html" class="sommaire2">&#xA0;<xsl:value-of select="INFORMATIONS/TITRE"/></a></div>
            </xsl:when>
            <xsl:otherwise>
                <div class="fondsel1sommaire">
                    <a href="{$prefixe}pages_{../INFORMATIONS/LABEL}/{@label}.html" class="sommairepage">&#x2022; <xsl:value-of select="@titre"/></a>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="sommaire-page">
        <xsl:variable name="prefixe">../</xsl:variable>
        <xsl:variable name="interface"><xsl:value-of select="$prefixe"/>interface/<xsl:choose>
            <xsl:when test="count(ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!='']) &gt; 0"><xsl:value-of select="ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!=''][1]/INFORMATIONS/INTERFACE"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$interface_par_defaut"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <div class="sommaire">
            <xsl:call-template name="sous-sommaire">
                <xsl:with-param name="pos"><xsl:value-of select="count(ancestor::XPAGES)"/></xsl:with-param>
                <xsl:with-param name="interface"><xsl:value-of select="$interface"/></xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    
    <!-- Mtadonnes -->
    
    <xsl:template match="INFORMATIONS">
    </xsl:template>
    
    <xsl:template match="TITRE">
        <h1><xsl:value-of select="."/></h1>
    </xsl:template>
    
    <xsl:template name="auteurs">
        <xsl:for-each select="ancestor-or-self::XPAGES[1]/INFORMATIONS">
            <xsl:choose>
                <xsl:when test="count(AUTEUR)=1">
                    <xsl:value-of select="$messages/message[@label='Auteur:']"/> <em><xsl:value-of select="AUTEUR"/></em><br/>
                </xsl:when>
                <xsl:when test="count(AUTEUR)&gt;1">
                    <xsl:value-of select="$messages/message[@label='Auteurs:']"/> 
                    <em><xsl:for-each select="AUTEUR"><xsl:value-of select="."/><xsl:if test="position()!=last()">, </xsl:if></xsl:for-each></em><br/>
                </xsl:when>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="DATECRE">
        <xsl:value-of select="$messages/message[@label='Date de cration&#xA0;:']"/> <i><xsl:apply-templates/></i>
    </xsl:template>
    
    <xsl:template match="DATEMAJ">
        <xsl:value-of select="$messages/message[@label='Date de mise  jour&#xA0;:']"/> <i><xsl:apply-templates/></i>
    </xsl:template>
    
    
    <!-- Elments de bloc -->
    
    <xsl:template match="SECTION">
        <xsl:variable name="classe"><xsl:choose>
            <xsl:when test="(@role='introduction' or @role='conclusion' or @role='exercice') and @importance='grande'"><xsl:value-of select="@role"/></xsl:when>
            <xsl:when test="@importance='grande'">section_cadre</xsl:when>
            <xsl:otherwise>section_normale</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <div class="{$classe}">
            <xsl:if test="@titre!=''">
                <xsl:element name="h{count(ancestor::SECTION)+2}">
                    <xsl:if test="@role='introduction' or @role='conclusion' or @role='prerequis' or @role='objectifs' or @role='rappel' or @role='definition' or @role='demonstration' or @role='exemple' or @role='conseil' or @role='remarque' or @role='attention' or @role='complement' or @role='methode' or @role='activite' or @role='exercice' or @role='bibliographie'">
                        <xsl:variable name="prefixe"><xsl:choose>
                            <xsl:when test="ancestor::PAGE[@label='index']"></xsl:when>
                            <xsl:otherwise>../</xsl:otherwise>
                        </xsl:choose></xsl:variable>
                        <xsl:variable name="interface"><xsl:value-of select="$prefixe"/>interface/<xsl:choose>
                            <xsl:when test="count(ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!='']) &gt; 0"><xsl:value-of select="ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!=''][1]/INFORMATIONS/INTERFACE"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="$interface_par_defaut"/></xsl:otherwise>
                        </xsl:choose></xsl:variable>
                        <img src="{$interface}/icones_sections/{@role}.png" width="40" height="40" alt="{@role}" class="icone_section"/>
                    </xsl:if>
                    <xsl:value-of select="@titre"/>
                </xsl:element>
            </xsl:if>
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    
    <xsl:template match="PARAGRAPHE">
        <p><xsl:apply-templates/></p>
    </xsl:template>
    
    
    <xsl:template match="LISTE">
        <xsl:if test="@titre!=''">
            <h2><xsl:value-of select="@titre"/></h2>
        </xsl:if>
        <ul>
            <xsl:apply-templates select="ITEM"/>
        </ul>
    </xsl:template>
    
    
    <xsl:template match="ITEM">
        <li><xsl:apply-templates/></li>
    </xsl:template>
    
    
    <xsl:template match="TABLEAU">
         <table border="1" cellspacing="0" cellpadding="2" class="tableau">
            <xsl:if test="@titre!=''">
                <caption><xsl:value-of select="@titre"/></caption>
            </xsl:if>
            <xsl:apply-templates/>
        </table>
    </xsl:template>
    
    
    <xsl:template match="TR">
        <tr><xsl:apply-templates/></tr>
    </xsl:template>
    
    
    <xsl:template match="TH">
        <th>
        <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
        <xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
        <xsl:if test="@align"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
        <xsl:apply-templates/>
        </th>
    </xsl:template>
    
    
    <xsl:template match="TD">
        <xsl:variable name="trpos"><xsl:number from="TABLEAU" count="TR"/></xsl:variable>
        <td class="tableaux{1+($trpos mod 2)}">
        <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
        <xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
        <xsl:if test="@align"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
        <xsl:apply-templates/></td>
    </xsl:template>
    
    
    <xsl:template match="ENVIMAGE">
        <xsl:variable name="prefixe"><xsl:choose>
            <xsl:when test="ancestor::PAGE[@label='index']"></xsl:when>
            <xsl:otherwise>../</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:variable name="interface"><xsl:value-of select="$prefixe"/>interface/<xsl:choose>
            <xsl:when test="count(ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!='']) &gt; 0"><xsl:value-of select="ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!=''][1]/INFORMATIONS/INTERFACE"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$interface_par_defaut"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:choose>
            <xsl:when test="@localisation='icne'">
                <xsl:for-each select="FICHIER[1]">
                    <xsl:variable name="label-ensemble" select="ancestor::XPAGES[1]/INFORMATIONS/LABEL"/>
                    <xsl:variable name="largeur1" select="document(concat($uri-site, '/images.xml'))/IMAGES/IMAGE[@contrib=$label-ensemble and @nom=current()/@nom]/@largeur1"/>
                    <xsl:variable name="hauteur1" select="document(concat($uri-site, '/images.xml'))/IMAGES/IMAGE[@contrib=$label-ensemble and @nom=current()/@nom]/@hauteur1"/>
                    <xsl:variable name="fichierhtml" select="concat('html_images/', translate(@nom, '/\\', '__'), '.html')"/>
                    <xsl:variable name="format"><xsl:call-template name="format-fichier">
                        <xsl:with-param name="nom" select="@nom"/>
                    </xsl:call-template></xsl:variable>
                    <xsl:choose>
                        <xsl:when test="$format='PNG' or $format='GIF' or $format='JPEG'">
                            <a href="{$fichierhtml}" target="blank" onclick="window.open('{$fichierhtml}', '', 'scrollbars=yes,scrolling=auto,toolbar=no,directories=no,menubar=no,status=no,resizable=no,width={$largeur1+35},height={$hauteur1+200}'); return false"><img alt="{@nom}" src="{$prefixe}pages_{$label-ensemble}/images_icone/{@nom}" align="right" border="0" class="iconeimage"/></a>
                        </xsl:when>
                        <xsl:when test="$format='MPEG'">
                            <a href="{$fichierhtml}" target="blank" onclick="window.open('{$fichierhtml}', '', 'scrollbars=yes,scrolling=auto,toolbar=no,directories=no,menubar=no,status=no, width={$largeur1+35},height={$hauteur1+200}'); return false"><img src="{$interface}/video.gif" width="50" height="50" alt="vido MPEG" align="right" border="0"/></a>
                        </xsl:when>
                        <xsl:otherwise><xsl:value-of select="$messages/message[@label='format inconnu (vrifier l_extension du nom du fichier)']"/></xsl:otherwise>
                    </xsl:choose>
                    <!-- html-figure est maintenant appel plus haut pour viter les imbrications de ecrire-fichier -->
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="@localisation!='page'">
                <xsl:call-template name="contenu-envimage">
                    <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    
    <!-- cration de l'encart pour la figure en page, appel par contenu-body -->
    <xsl:template name="figures-page">
        <xsl:param name="prefixe">../</xsl:param>
        <xsl:for-each select=".//ENVIMAGE[@localisation='page']">
            <div class="zone_figure">
                <xsl:call-template name="contenu-envimage">
                    <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                </xsl:call-template>
            </div>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="contenu-envimage">
        <xsl:param name="prefixe">../</xsl:param>
        <xsl:variable name="classe-div"><xsl:choose>
            <xsl:when test="@localisation='page'">cadre_zone_figure</xsl:when>
            <xsl:otherwise>cadre_figure_texte</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <div class="{$classe-div}">
            <xsl:if test="@titre!=''">
                <div class="titrefigure"><xsl:value-of select="@titre"/></div>
            </xsl:if>
        
            <xsl:variable name="label-ensemble" select="ancestor::XPAGES[1]/INFORMATIONS/LABEL"/>
            <xsl:for-each select="FICHIER">
                <xsl:variable name="nomfichier" select="@nom"/>
                <xsl:variable name="localisation" select="../@localisation"/>
                <xsl:variable name="largeur1" select="document(concat($uri-site, '/images.xml'))/IMAGES/IMAGE[@contrib=$label-ensemble and @nom=$nomfichier and @localisation=$localisation]/@largeur1"/>
                <xsl:variable name="hauteur1" select="document(concat($uri-site, '/images.xml'))/IMAGES/IMAGE[@contrib=$label-ensemble and @nom=$nomfichier and @localisation=$localisation]/@hauteur1"/>
                <xsl:variable name="redim" select="document(concat($uri-site, '/images.xml'))/IMAGES/IMAGE[@contrib=$label-ensemble and @nom=$nomfichier and @localisation=$localisation]/@redim"/>
                <xsl:variable name="format"><xsl:call-template name="format-fichier">
                    <xsl:with-param name="nom" select="@nom"/>
                </xsl:call-template></xsl:variable>
                <xsl:choose>
                    <xsl:when test="$redim='oui'">
                        <xsl:variable name="largeur2" select="document(concat($uri-site, '/images.xml'))/IMAGES/IMAGE[@contrib=$label-ensemble and @nom=$nomfichier and @localisation=$localisation]/@largeur2"/>
                        <xsl:variable name="hauteur2" select="document(concat($uri-site, '/images.xml'))/IMAGES/IMAGE[@contrib=$label-ensemble and @nom=$nomfichier and @localisation=$localisation]/@hauteur2"/>
                        <xsl:variable name="href" select="concat('html_images/', translate($nomfichier, '/\\', '__'), '.html')"/>
                        <xsl:choose>
                            <xsl:when test="$format='PNG' or $format='GIF' or $format='JPEG'">
                                <a href="{$href}" target="blank" onclick="window.open('{$href}', '', 'scrollbars=yes,scrolling=auto,toolbar=no,directories=no,menubar=no,status=no,resizable=no,width={$largeur1+35},height={$hauteur1+200}'); return false"><img alt="{$nomfichier}" src="{$prefixe}pages_{$label-ensemble}/images_{$localisation}/{$nomfichier}" width="{$largeur2}" height="{$hauteur2}" border="0"/></a>
                            </xsl:when>
                            <xsl:when test="$format='MPEG'">
                                <embed src="{$prefixe}pages_{$label-ensemble}/images_{$localisation}/{$nomfichier}" width="{$largeur2}" height="{$hauteur2}">
                                    <noembed><xsl:value-of select="$messages/message[@label='Erreur: ce navigateur ne gre pas EMBED']"/></noembed>
                                </embed>
                            </xsl:when>
                            <xsl:otherwise><xsl:value-of select="$messages/message[@label='format inconnu (vrifier l_extension du nom du fichier)']"/></xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="$format='PNG' or $format='GIF' or $format='JPEG'">
                                <img alt="{$nomfichier}" src="{$prefixe}pages_{$label-ensemble}/{$nomfichier}" width="{$largeur1}" height="{$hauteur1}"/>
                            </xsl:when>
                            <xsl:when test="$format='MPEG'">
                                <embed src="{$prefixe}pages_{$label-ensemble}/{$nomfichier}" width="{$largeur1}" height="{$hauteur1}">
                                    <noembed><xsl:value-of select="$messages/message[@label='Erreur: ce navigateur ne gre pas EMBED']"/></noembed>
                                </embed>
                            </xsl:when>
                            <xsl:otherwise><xsl:value-of select="$messages/message[@label='format inconnu (vrifier l_extension du nom du fichier)']"/></xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:apply-templates select="LEGENDE|CREDIT"/>
        </div>
    </xsl:template>
    
    <!-- cration du fichier HTML pour la grande image -->
    <xsl:template name="html-figure">
        <xsl:param name="largeur1"/>
        <xsl:param name="hauteur1"/>
        <xsl:variable name="interface">../../interface/<xsl:choose>
            <xsl:when test="count(ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!='']) &gt; 0"><xsl:value-of select="ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!=''][1]/INFORMATIONS/INTERFACE"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$interface_par_defaut"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:variable name="cheminfichier" select="@nom"/>
        <xsl:variable name="nomfichier"><xsl:call-template name="nom-fichier">
            <xsl:with-param name="chemin" select="$cheminfichier"/>
        </xsl:call-template></xsl:variable>
        <xsl:variable name="format"><xsl:call-template name="format-fichier">
            <xsl:with-param name="nom" select="$nomfichier"/>
        </xsl:call-template></xsl:variable>
        <xsl:call-template name="ecrire-fichier">
            <xsl:with-param name="fichier" select="concat($chemin-site, $sep, 'pages_', ancestor::XPAGES[1]/INFORMATIONS/LABEL, $sep, 'html_images', $sep, translate($cheminfichier, '/\\', '__'), '.html')"/>
            <xsl:with-param name="contenu">
                <html>
                <head>
                    <title><xsl:value-of select="../@titre"/></title>
                    <link type="text/css" rel="stylesheet" href="{$interface}/{$feuille-de-style}"/>
                </head>
                <body bgcolor="#FFFFFF" text="#000000">
                    <div align="center">
                        <xsl:if test="../@titre!=''">
                            <div class="titrefigure"><xsl:value-of select="../@titre"/></div>
                        </xsl:if>
                        <xsl:choose>
                            <xsl:when test="$format='PNG' or $format='GIF' or $format='JPEG'">
                                <img src="../{$cheminfichier}" width="{$largeur1}" height="{$hauteur1}" alt="{$nomfichier}"/>
                            </xsl:when>
                            <xsl:when test="$format='MPEG'">
                                <embed src="../{$cheminfichier}" width="{$largeur1}" height="{$hauteur1}">
                                    <noembed><xsl:value-of select="$messages/message[@label='Erreur: ce navigateur ne gre pas EMBED']"/></noembed>
                                </embed>
                            </xsl:when>
                            <xsl:otherwise><xsl:value-of select="$messages/message[@label='format inconnu (vrifier l_extension du nom du fichier)']"/></xsl:otherwise>
                        </xsl:choose>
                        <xsl:apply-templates select="../LEGENDE|../CREDIT"/>
                    </div>
                </body>
                </html>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    
    <xsl:template match="FICHIER">
        <xsl:variable name="prefixe"><xsl:choose>
            <xsl:when test="ancestor::PAGE[@label='index']"></xsl:when>
            <xsl:otherwise>../</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:variable name="label-ensemble" select="ancestor::XPAGES[1]/INFORMATIONS/LABEL"/>
        <img alt="{@nom}" src="{$prefixe}pages_{$label-ensemble}/{@nom}"/>
    </xsl:template>
    
    
    <xsl:template match="LEGENDE">
        <div class="legende">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    
    <xsl:template match="CREDIT">
        <div class="credit"><em><xsl:value-of select="$messages/message[@label='Crdit :']"/> </em><xsl:apply-templates/></div>
    </xsl:template>
    
    
    <xsl:template match="APPLET|FLASH">
        <xsl:variable name="prefixe"><xsl:choose>
            <xsl:when test="ancestor::PAGE[@label='index']"></xsl:when>
            <xsl:otherwise>../</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:variable name="interface"><xsl:value-of select="$prefixe"/>interface/<xsl:choose>
            <xsl:when test="count(ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!='']) &gt; 0"><xsl:value-of select="ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!=''][1]/INFORMATIONS/INTERFACE"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$interface_par_defaut"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        
        <xsl:choose>
            <xsl:when test="@localisation='icne' and $affichage='web'">
                <xsl:variable name="rep" select="concat($chemin-site, '/', 'pages_', ancestor::XPAGES[1]/INFORMATIONS/LABEL)"/>
                <xsl:variable name="numero"><xsl:number level="any" from="XPAGES" count="APPLET|FLASH"/></xsl:variable>
                <xsl:variable name="nomfichiermedia"><xsl:value-of select="concat('media',$numero)"/>.html</xsl:variable>
                <xsl:variable name="fichiermedia"><xsl:value-of select="concat($rep,$sep,$nomfichiermedia)"/></xsl:variable>
                <xsl:variable name="icone"><xsl:choose>
                    <xsl:when test="self::APPLET">applet.gif</xsl:when>
                    <xsl:when test="self::FLASH">flash.gif</xsl:when>
                </xsl:choose></xsl:variable>
                <br/><a href="{$nomfichiermedia}" target="blank"><img src="{$interface}/{$icone}" width="45" height="45" border="0" alt="{$icone}"/></a>
                <xsl:call-template name="ecrire-fichier">
                    <xsl:with-param name="fichier" select="$fichiermedia"/>
                    <xsl:with-param name="contenu">
                        <html>
                        <head>
                            <title><xsl:value-of select="concat('applet ',$numero)"/></title>
                            <link type="text/css" rel="stylesheet" href="{$interface}/{$feuille-de-style}"/>
                        </head>
                        <body>
                            <xsl:call-template name="contenu-media">
                                <xsl:with-param name="interface"><xsl:value-of select="$interface"/></xsl:with-param>
                                <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                            </xsl:call-template>
                        </body>
                        </html>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="@localisation='page' and $affichage='web'">
                <div class="zone_figure">
                    <xsl:call-template name="contenu-media">
                        <xsl:with-param name="interface"><xsl:value-of select="$interface"/></xsl:with-param>
                        <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                    </xsl:call-template>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="contenu-media">
                    <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
        <br/>
    </xsl:template>
    
    <xsl:template name="contenu-media">
    	<xsl:param name="interface"/>
        <xsl:param name="prefixe">../</xsl:param>
        
        <xsl:variable name="classe-div"><xsl:choose>
            <xsl:when test="@localisation='page'">cadre_zone_figure</xsl:when>
            <xsl:otherwise>cadre_applet_texte</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <div class="{$classe-div}">
            <xsl:if test="@localisation!='page'">
                <xsl:attribute name="style">width: <xsl:value-of select="@largeur + 12"/>px;</xsl:attribute>
            </xsl:if>
            <xsl:if test="@titre!=''">
                <div class="titrefigure"><xsl:value-of select="@titre"/></div>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="self::APPLET and $affichage='web'">
                    <applet code="{@classe}" archive="{@archive}" width="{@largeur}" height="{@hauteur}">
                        <xsl:apply-templates select="PARAM"/>
                        <xsl:value-of select="$messages/message[@label='Java n_est pas activ.']"/>
                    </applet>
                </xsl:when>
                <xsl:when test="self::FLASH and $affichage='web'">
                    <object type="application/x-shockwave-flash" data="{@fichier}" width="{@largeur}" height="{@hauteur}" title="{@titre}">
                        <param name="movie" value="{@fichier}"/>
                        <xsl:variable name="parametres"><xsl:for-each select="PARAM">
                            <xsl:value-of select="concat(@nom,'=',@valeur,'&#38;')" />
                        </xsl:for-each></xsl:variable>
                        <xsl:if test="$parametres != ''">
                            <param name="flashvars" value="{$parametres}"/>
                        </xsl:if>
                        <xsl:value-of select="$messages/message[@label='Erreur: plugin Flash absent ou dsactiv ?']"/>
                    </object>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="icone"><xsl:choose>
                        <xsl:when test="self::APPLET">applet.gif</xsl:when>
                        <xsl:when test="self::FLASH">flash.gif</xsl:when>
                    </xsl:choose></xsl:variable>
                    <img src="{$interface}/{$icone}" width="45" height="45" border="0" alt="{$icone}"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates select="LEGENDE"/>
            <xsl:apply-templates select="CREDIT"/>
        </div>
    </xsl:template>
    
    
    <xsl:template match="PARAM">
        <param name="{@nom}" value="{@valeur}"/>
    </xsl:template>
    
    
    <xsl:template match="COMMENTAIRE">
    </xsl:template>
    
    
    <!-- Elments mlangs  du texte  -->
    
    <xsl:template match="LIENPAGE">
        <xsl:variable name="prefixe"><xsl:choose>
            <xsl:when test="ancestor::PAGE[@label='index']"></xsl:when>
            <xsl:otherwise>../</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:choose>
            <xsl:when test="@contribution='' or not(@contribution)">
                <a href="{@page}.html" class="lien"><xsl:apply-templates/></a>
            </xsl:when>
            <xsl:when test="@page='' or not(@page)">
                <a href="{concat($prefixe,'pages_',@contribution,'/',//XPAGES[INFORMATIONS/LABEL=current()/@contribution]/PAGE[1]/@label,'.html')}" class="lien"><xsl:apply-templates/></a>
            </xsl:when>
            <xsl:otherwise>
                <a href="{concat($prefixe,'pages_',@contribution,'/',@page,'.html')}" class="lien"><xsl:apply-templates/></a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <xsl:template match="LIENWEB">
        <a href="{@url}" class="lien" target="_blank"><xsl:apply-templates/></a>
    </xsl:template>
    
    
    <xsl:template match="EQUATION|EQUATEX">
        <xsl:variable name="label-ensemble" select="ancestor::XPAGES[1]/INFORMATIONS/LABEL"/>
        <!--
        <xsl:variable name="largeur1" select="document(concat($uri-site, '/images.xml'))/IMAGES/IMAGE[@contrib=$label-ensemble and @nom=current()/@image]/@largeur1"/>
        <xsl:variable name="hauteur1" select="document(concat($uri-site, '/images.xml'))/IMAGES/IMAGE[@contrib=$label-ensemble and @nom=current()/@image]/@hauteur1"/>
        pour l'instant les dimensions ne sont pas dans ce fichier
        -->
        <xsl:variable name="numero"><xsl:number from="XPAGES" count="EQUATION|EQUATEX" level="any"/></xsl:variable>
        <xsl:variable name="prefixe"><xsl:choose>
            <xsl:when test="ancestor::ENVIMAGE[@localisation='icne']">../../</xsl:when>
            <xsl:when test="ancestor::PAGE[@label='index']"></xsl:when>
            <xsl:otherwise>../</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <img alt="{@texte}" src="{$prefixe}pages_{$label-ensemble}/equations_{$label-ensemble}/equation{$numero}.png" class="maths"/>
    </xsl:template>
    
    
    <xsl:template match="GLOSSAIRE">
        <xsl:variable name="prefixe"><xsl:choose>
            <xsl:when test="ancestor::PAGE[@label='index']"></xsl:when>
            <xsl:otherwise>../</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:variable name="motref"><xsl:choose>
            <xsl:when test="@ref!=''"><xsl:value-of select="@ref"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="@mot"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:variable name="definition"><xsl:choose>
            <xsl:when test="normalize-space(.)!=''"><xsl:value-of select="."/></xsl:when>
            <xsl:otherwise><xsl:value-of select="//GLOSSAIRE[@ref=$motref]"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:variable name="motreftrans" select="translate($motref,' ','_aaeeeiioouu')"/>
        <a href="{$prefixe}pages_{ancestor::XPAGES[last()]/INFORMATIONS/LABEL}/glossaire.html#{$motreftrans}" title="{$definition}" class="glossaire" target="blank"><xsl:value-of select="@mot"/></a>
    </xsl:template>
    
    
    <xsl:template match="EM">
        <em><xsl:apply-templates/></em>
    </xsl:template>
    
    
    <xsl:template match="SUB">
        <sub><xsl:apply-templates/></sub>
    </xsl:template>
    
    
    <xsl:template match="SUP">
        <sup><xsl:apply-templates/></sup>
    </xsl:template>
    
    
    <xsl:template match="CODE">
        <tt><xsl:apply-templates/></tt>
    </xsl:template>
    
    
    <xsl:template match="NBSP">&#xA0;</xsl:template>
    
    
    
    <!-- Page d'entre du site -->
    
	<xsl:template name="page-entree">
        <xsl:variable name="interface">interface/<xsl:choose>
            <xsl:when test="count(ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!='']) &gt; 0"><xsl:value-of select="ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!=''][1]/INFORMATIONS/INTERFACE"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$interface_par_defaut"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <html>
        <head>
            <title><xsl:value-of select="ancestor-or-self::XPAGES[last()]/INFORMATIONS/TITRE"/></title>
            <link type="text/css" rel="stylesheet" href="{$interface}/style.css"/>
        </head>
        
        <body class="page">
            <xsl:call-template name="zone_logo">
                <xsl:with-param name="prefixe"></xsl:with-param>
            </xsl:call-template>
            
            <xsl:call-template name="zone_bandeau"/>
            
            <xsl:if test="count(ancestor-or-self::XPAGES[last()]/XPAGES) &gt; 1">
                <xsl:call-template name="zone_rubriques">
                    <xsl:with-param name="prefixe"></xsl:with-param>
                </xsl:call-template>
            </xsl:if>
            
            <div class="zone_sommaire">
                <div class="zone_outils">
                    <a href="pages_{ancestor-or-self::XPAGES[1]/INFORMATIONS/LABEL}/sommaire.html" title="{$messages/message[@label='Sommaire']}"><img src="{$interface}/sommaire_petit.gif" width="25" height="25" border="0" alt="{$messages/message[@label='Sommaire']}"/></a>
                    <xsl:if test="//GLOSSAIRE">
                        &#xA0;&#xA0;
                        <a href="pages_{ancestor-or-self::XPAGES[1]/INFORMATIONS/LABEL}/glossaire.html" title="{$messages/message[@label='Glossaire']}"><img src="{$interface}/glossaire_petit.gif" width="25" height="25" border="0" alt="{$messages/message[@label='Glossaire']}"/></a>
                    </xsl:if>
                </div>
                
            </div>
            
            <div class="zone_titre">
                <table cellspacing="0" cellpadding="0"><tr>
                <td><h1><xsl:value-of select="ancestor-or-self::XPAGES[last()]/INFORMATIONS/TITRE"/></h1></td>
                </tr></table>
            </div>
            
            <div class="zone_contenu_entree">
                <!-- pb de chemin vers html_images
                <xsl:if test=".//ENVIMAGE[@localisation='page']">
                    <xsl:call-template name="figures-page">
                        <xsl:with-param name="prefixe"></xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
                -->
                <div class="zone_texte">
                    <xsl:call-template name="infos-erreurs"/>
                    <xsl:choose>
                        <xsl:when test="self::PAGE">
                            <xsl:apply-templates/>
                        </xsl:when>
                        <xsl:otherwise>
                            <p><xsl:value-of select="$messages/message[@label='Vous pouvez dfinir une page d_accueil du site en crant une page avec le label _index_.']"/></p>
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
            </div>
        </body>
        </html>
    </xsl:template>
    
    
    <!-- Sommaire et Glossaire du site -->
    
	<xsl:template name="page-sommaire">
        <xsl:variable name="prefixe">../</xsl:variable>
        <xsl:variable name="interface"><xsl:value-of select="$prefixe"/>interface/<xsl:choose>
            <xsl:when test="count(ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!='']) &gt; 0"><xsl:value-of select="ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!=''][1]/INFORMATIONS/INTERFACE"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$interface_par_defaut"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <html>
        <head>
            <title><xsl:value-of select="$messages/message[@label='Sommaire']"/></title>
            <link type="text/css" rel="stylesheet" href="{$interface}/style.css"/>
        </head>
        
        <body class="page">
            <xsl:call-template name="zone_logo"/>
            
            <xsl:call-template name="zone_bandeau"/>
            
            <xsl:if test="count(XPAGES) &gt; 1">
                <xsl:call-template name="zone_rubriques"/>
            </xsl:if>
            
            <div class="zone_sommaire">
                <div class="zone_outils">
                    <a href="{$prefixe}index.html" title="{$messages/message[@label='entre du site']}"><img src="{$interface}/home.gif" width="25" height="25" alt="home" border="0"/></a>
                    <xsl:if test="//GLOSSAIRE">
                        &#xA0;&#xA0;
                        <a href="glossaire.html" title="{$messages/message[@label='Glossaire']}"><img src="{$interface}/glossaire_petit.gif" width="25" height="25" border="0" alt="{$messages/message[@label='Glossaire']}"/></a>
                    </xsl:if>
                </div>
                
            </div>
            
            <div class="zone_titre">
                <table cellspacing="0" cellpadding="0"><tr>
                <td><h1><xsl:value-of select="$messages/message[@label='Sommaire']"/></h1></td>
                </tr></table>
            </div>
            
            <div class="zone_contenu_sommaire">
                <div class="zone_texte">
                    <ul>
                        <xsl:apply-templates select="PAGE[@label!='index']|XPAGES" mode="sommaire-site"/>
                    </ul>
                </div>
            </div>
        </body>
        </html>
    </xsl:template>
    
    <xsl:template match="XPAGES" mode="sommaire-site">
        <xsl:variable name="prefixe">../</xsl:variable>
        <li>
            <a href="{$prefixe}pages_{INFORMATIONS/LABEL}/index.html" class="sommaire2"><xsl:value-of select="INFORMATIONS/TITRE"/></a>
            <ul>
                <xsl:apply-templates select="PAGE|XPAGES" mode="sommaire-site"/>
            </ul>
        </li>
    </xsl:template>
    
    <xsl:template match="PAGE" mode="sommaire-site">
        <xsl:variable name="prefixe">../</xsl:variable>
        <li>
            <a href="{$prefixe}pages_{ancestor::XPAGES[1]/INFORMATIONS/LABEL}/{@label}.html" class="sommairepage"><xsl:value-of select="@titre"/></a>
        </li>
    </xsl:template>
    
    
	<xsl:template name="page-glossaire">
        <xsl:variable name="prefixe">../</xsl:variable>
        <xsl:variable name="interface"><xsl:value-of select="$prefixe"/>interface/<xsl:choose>
            <xsl:when test="count(ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!='']) &gt; 0"><xsl:value-of select="ancestor-or-self::XPAGES[INFORMATIONS/INTERFACE!=''][1]/INFORMATIONS/INTERFACE"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$interface_par_defaut"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <html>
        <head>
            <title><xsl:value-of select="$messages/message[@label='Glossaire']"/></title>
            <link type="text/css" rel="stylesheet" href="{$interface}/style.css"/>
        </head>
        <body class="page">
            <xsl:call-template name="zone_logo"/>
            
            <xsl:call-template name="zone_bandeau"/>
            
            <xsl:if test="count(XPAGES) &gt; 1">
                <xsl:call-template name="zone_rubriques"/>
            </xsl:if>
            
            <div class="zone_sommaire">
                <div class="zone_outils">
                    <a href="{$prefixe}index.html" title="{$messages/message[@label='entre du site']}"><img src="{$interface}/home.gif" width="25" height="25" alt="{$messages/message[@label='entre du site']}" border="0"/></a>
                    &#xA0;&#xA0;
                    <a href="sommaire.html" title="{$messages/message[@label='Sommaire']}"><img src="{$interface}/sommaire_petit.gif" width="25" height="25" border="0" alt="{$messages/message[@label='Sommaire']}"/></a>
                    &#xA0;&#xA0;
                    <img src="{$interface}/glossaire_petit.gif" width="25" height="25" border="0" alt="{$messages/message[@label='Glossaire']}"/>
                </div>
                
            </div>
            
            <div class="zone_titre">
                <table cellspacing="0" cellpadding="0"><tr>
                <td><h1><xsl:value-of select="$messages/message[@label='Glossaire']"/></h1></td>
                </tr></table>
            </div>
            
            <div class="zone_contenu_glossaire">
                <div class="zone_texte">
                    <xsl:call-template name="lettres-glossaire">
                        <xsl:with-param name="lettres">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:with-param>
                    </xsl:call-template>
                    <br/><br/><br/><br/><br/><br/> <!-- pour que les liens pointent vers le haut de la page -->
                </div>
            </div>
        </body>
        </html>
    </xsl:template>
    
    
    <xsl:template name="lettres-glossaire">
    	<xsl:param name="lettres"/>
        
        <xsl:variable name="lettre" select="substring($lettres,1,1)"/>
        
   		<h2>- <xsl:value-of select="$lettre"/> -</h2>
   		<dl>
  			<xsl:apply-templates select="//GLOSSAIRE[translate(substring(@ref,1,1),'abcdefghijklmnopqrstuvwxyz','AABCCDEEEEFGHIIIJKLMNOOPQRSTUUVWXYZ')=$lettre or (not(@ref) and translate(substring(@mot,1,1),'abcdefghijklmnopqrstuvwxyz','AABCCDEEEEFGHIIIJKLMNOOPQRSTUUVWXYZ')=$lettre)]" mode="glossaire-site">
  				<xsl:sort select="concat(@ref,@mot)"/>
  			</xsl:apply-templates>
        </dl>
        <xsl:if test="string-length($lettres)&gt;1">
            <xsl:call-template name="lettres-glossaire">
                <xsl:with-param name="lettres"><xsl:value-of select="substring($lettres,2)"/></xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="GLOSSAIRE" mode="glossaire-site">
        <xsl:variable name="motref"><xsl:choose>
            <xsl:when test="@ref!=''"><xsl:value-of select="@ref"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="@mot"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        
        <xsl:if test="$motref != ''">
            <xsl:if test="normalize-space(.)!=''">
                <xsl:variable name="motreftrans" select="translate($motref,' ','_aaeeeiioouu')"/>
                <dt><a name="{$motreftrans}"><b><xsl:value-of select="$motref"/></b></a></dt>
                <dd><xsl:value-of select="."/><br/><br/></dd>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    
    <!-- Templates outils -->
    
    <xsl:template name="format-fichier">
    <!-- renvoit le format suppos d'un fichier d'image/animation  partir de son nom, en utilisant l'extension -->
    <!-- formats reconnus: PNG, JPEG, GIF, MPEG, MNG -->
    <!-- renvoit '?' si le format n'est pas reconnu -->
        <xsl:param name="nom"/>
        <xsl:variable name="ext"><xsl:call-template name="extension-fichier"><xsl:with-param name="nom" select="$nom"/></xsl:call-template></xsl:variable>
        <xsl:variable name="extmin" select="translate($ext, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
        <xsl:choose>
            <xsl:when test="$extmin='png'">PNG</xsl:when>
            <xsl:when test="$extmin='jpg' or $extmin='jpeg'">JPEG</xsl:when>
            <xsl:when test="$extmin='gif'">GIF</xsl:when>
            <xsl:when test="$extmin='mpg' or $extmin='mpeg'">MPEG</xsl:when>
            <xsl:when test="$extmin='mng'">MNG</xsl:when>
            <xsl:otherwise>?</xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="extension-fichier">
    <!-- renvoit l'extension d'un fichier  partir de son nom -->
        <xsl:param name="nom"/>
        <xsl:choose>
            <xsl:when test="contains($nom,'.')">
                <xsl:call-template name="extension-fichier"><xsl:with-param name="nom" select="substring-after($nom,'.')"/></xsl:call-template>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="$nom"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="nom-fichier">
    <!-- renvoit le nom d'un fichier  partir du chemin-->
        <xsl:param name="chemin"/>
        <xsl:choose>
            <xsl:when test="contains($chemin,$sep)">
                <xsl:call-template name="nom-fichier"><xsl:with-param name="chemin" select="substring-after($chemin,$sep)"/></xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$chemin"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="rep-uri">
        <!-- renvoit le chemin du rpertoire d'un fichier  partir de l'URI complte, sous forme d'URI  -->
        <xsl:param name="chemin"/>
        <!-- sparateur de chemins ( normalement / mais parfois \ avec file:// sur Windows ? ) -->
        <xsl:variable name="sepuri"><xsl:choose>
            <xsl:when test="contains($chemin, '\')">\</xsl:when>
            <xsl:otherwise>/</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:choose>
            <xsl:when test="contains($chemin,$sepuri) and contains(substring-after($chemin,$sepuri),$sepuri)">
                <xsl:value-of select="substring-before($chemin,$sepuri)"/><xsl:value-of select="$sepuri"/><xsl:call-template name="rep-uri"><xsl:with-param name="chemin" select="substring-after($chemin,$sepuri)"/></xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="substring-before($chemin,$sepuri)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="rep-fichier">
        <!-- renvoit le chemin du rpertoire d'un fichier  partir du chemin complet vers le fichier-->
        <xsl:param name="chemin"/>
        <xsl:choose>
            <xsl:when test="contains($chemin,$sep) and contains(substring-after($chemin,$sep),$sep)">
                <xsl:value-of select="substring-before($chemin,$sep)"/><xsl:value-of select="$sep"/><xsl:call-template name="rep-fichier"><xsl:with-param name="chemin" select="substring-after($chemin,$sep)"/></xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="substring-before($chemin,$sep)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="ecrire-fichier">
        <xsl:param name="fichier"/> <!-- chemin du fichier dans lequel on veut crire -->
        <xsl:param name="contenu"/> <!-- contenu  crire dans le fichier -->
        <xsl:param name="methode"><xsl:choose>
            <xsl:when test="translate(substring($fichier, string-length($fichier)-4, 4), 'XML', 'xml') = '.xml'">xml</xsl:when>
            <xsl:otherwise>html</xsl:otherwise>
        </xsl:choose></xsl:param>
        <xsl:param name="encodage" select="'UTF-8'"/> <!-- Sablotron ne connait pas autre chose -->
        <xsl:param name="indentation" select="'no'"/>
        <xsl:choose>
            <!-- Xalan et XSLTC -->
            <!-- attention, Xalan gre les chemins relatifs mais pas XSLTC -->
            <xsl:when test="element-available('xalanredirect:write')">
                <xalanredirect:write file="{$fichier}">
                    <xsl:copy-of select="$contenu"/>
                </xalanredirect:write>
            </xsl:when>
            
            <!-- EXSLT -->
            <!-- attention, href doit tre une URI -->
            <xsl:when test="element-available('exsl:document')">
                <exsl:document href="file://{$fichier}" method="{$methode}" encoding="{$encodage}" indent="{$indentation}">
                    <xsl:copy-of select="$contenu"/>
                </exsl:document>
            </xsl:when>
            
            <xsl:otherwise>
                <xsl:message terminate="yes">
                    <xsl:value-of select="$messages/message[@label='Impossible de crer un fichier avec le processeur XSLT de']"/> 
                    <xsl:value-of select="system-property('xsl:vendor')"/>
                </xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
