<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" encoding="ISO-8859-1"/>

<!-- options (valeurs: oui|non) -->
<xsl:param name="commentaires"><xsl:choose>
    <xsl:when test="/PRESENTATION/METADONNEES/OPTIONS/COMMENTAIRES"><xsl:value-of select="/PRESENTATION/METADONNEES/OPTIONS/COMMENTAIRES"/></xsl:when>
    <xsl:otherwise>non</xsl:otherwise></xsl:choose>
</xsl:param>

<xsl:param name="impression"><xsl:choose>
    <xsl:when test="/PRESENTATION/METADONNEES/OPTIONS/IMPRESSION"><xsl:value-of select="/PRESENTATION/METADONNEES/OPTIONS/IMPRESSION"/></xsl:when>
    <xsl:otherwise>non</xsl:otherwise></xsl:choose>
</xsl:param>

    <xsl:template match="PRESENTATION">
        <html>
        <head>
            <xsl:choose>
            <xsl:when test="normalize-space(TITRE)!=''">
                <title><xsl:value-of select="TITRE"/></title>
            </xsl:when>
            <xsl:otherwise>
                <title>Prsentation</title>
            </xsl:otherwise>
            </xsl:choose>
            <style type="text/css">
                <xsl:call-template name="css"/>
            </style>
            <xsl:call-template name="javascript"/>
        </head>
        <body>
            <a name="0"/>
            <div class="sommaire">
                <xsl:apply-templates select="LOGO"/>
                <xsl:apply-templates select="METADONNEES/DATECRE"/>
                <xsl:if test="normalize-space(TITRE)!=''">
                    <h1><xsl:value-of select="TITRE"/></h1>
                </xsl:if>
                <xsl:if test="count(METADONNEES/AUTEUR)&gt;0">
                    <div class="auteur">- <xsl:apply-templates select="METADONNEES/AUTEUR"/></div>
                </xsl:if>
                <ol>
                    <xsl:for-each select="SECTION">
                        <li>
                            <a href="#{position()}" class="elsommaire"><xsl:choose>
                                <xsl:when test="normalize-space(TITRE)!=''"><xsl:value-of select="TITRE"/></xsl:when>
                                <xsl:otherwise>section <xsl:value-of select="position()"/></xsl:otherwise>
                            </xsl:choose></a>
                        </li>
                    </xsl:for-each>
                </ol>
                <xsl:if test="$commentaires='oui'">
                    <div class="commentaire">
                        note: les commentaires sont affichs
                    </div>
                </xsl:if>
            </div>
            <xsl:apply-templates select="SECTION"/>
        </body>
        </html>
    </xsl:template>
    
    <xsl:template name="css">
body { background: #FFFFFF }
h1 { text-align: center; font-size: 150%; font-family: sans-serif; color: #963232 }
h2 { text-align: center; font-size: 110%; font-weight: bold; font-family: sans-serif; color: #963232 }
h3 { font-size: 100%; font-weight: bold; font-family: serif; margin-bottom: 0.5em }
.auteur { text-align: center }
.date { text-align: left }
.sommaire { page-break-after: always; background: #F5F5FF; margin: 0.5em; padding: 0.5em; <xsl:if test="$impression='non'">border: gray outset</xsl:if> }
.section { page-break-after: always; background: #FFFFEB; margin: 2em 0.5em; padding: 0.5em; <xsl:if test="$impression='non'">border: gray outset</xsl:if> }
.titreimage { text-align: center; font-weight: bold; font-family: sans-serif; background-color: #E0E0FF }
.envimage { text-align: center; border: gray outset; padding: 0; margin: 1em; background: #EBFFEB }
.legende { font-family: sans-serif; margin-top: 1em }
p { text-indent: 1em; text-align: justify; margin-top: 0.5em }
pre { background: #EBFFEB; padding-left: 2em; padding-bottom: 0.5em }
tt { color: #963232 }
ul { margin-top: 0.5em }
li { margin-bottom: 0.5em; }
dt { font-weight: bold; }
dd { margin-bottom: 0.5em; }
th { background: #FFF0E0 }
.tableau1 { background: #FFFAE0 }
.tableau2 { background: #FFF5E0 }
.elsommaire { font-size: 110%; color: #000000; text-decoration: none; font-weight: bold }
.elsommaire:hover { font-size: 110%; color: #663399; text-decoration: none; font-weight: bold }
.commentaire { margin: 1em; color: #196419 }
.equation { vertical-align : middle }
    </xsl:template>
    
    <xsl:template name="javascript">
<script type='text/javascript'>
var n = 0;
document.onkeydown = onKeyDown;
function onKeyDown(event) {
    var code = event.keyCode;
    switch (code) {
    case 37:
        // left
        n = n - 1;
        location.href='#' + n;
        break
    case 38:
        // up
        n = 0;
        location.href='#' + n;
        break
    case 39:
        // right
        n = n + 1;
        location.href='#' + n;
        break
    case 40:
        // down
        n = n + 1;
        location.href='#' + n;
        break
    }
}
</script>
    </xsl:template>
    
    <xsl:template match="LOGO">
        <xsl:choose>
            <xsl:when test="@url!=''">
                <a href="{@url}"><img src="{@fichier}" align="right" alt="{@alt}" border="0"/></a>
            </xsl:when>
            <xsl:otherwise>
                <img src="{@fichier}" align="right" alt="{@alt}"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="SECTION">
        <div class="section">
            <xsl:variable name="numero"><xsl:number count="SECTION"/></xsl:variable>
            <a name="{$numero}"/>
            <xsl:if test="$impression='oui'">
                <div align="right"><tt><xsl:value-of select="$numero"/></tt></div>
            </xsl:if>
            <xsl:if test="TITRE!=''">
                <h2><xsl:value-of select="TITRE"/></h2>
            </xsl:if>
            <xsl:apply-templates/>
            <xsl:if test="$impression='non'">
                <br/>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template match="AUTEUR">
        <xsl:value-of select="."/> -
    </xsl:template>
    
    <xsl:template match="DATECRE">
        <div class="date"><xsl:value-of select="."/></div>
    </xsl:template>
    
    <xsl:template match="TITRE">
    </xsl:template>
    
    <xsl:template match="PARAGRAPHE">
        <xsl:if test="normalize-space(TITRE)!=''">
            <h3><xsl:value-of select="TITRE"/></h3>
        </xsl:if>
        <p><xsl:apply-templates/></p>
    </xsl:template>

    <xsl:template match="EXEMPLE">
        <h3>Exemple :</h3>
        <pre><xsl:apply-templates/></pre>
    </xsl:template>
    
    <xsl:template match="CODE">
        <tt><xsl:apply-templates/></tt>
    </xsl:template>
    
    <xsl:template match="EMPHASE">
        <em><xsl:apply-templates/></em>
    </xsl:template>
    
    <xsl:template match="LIEN">
        <a href="{@href}"><xsl:apply-templates/></a>
    </xsl:template>
    
    <xsl:template match="LISTE">
        <xsl:if test="normalize-space(TITRE)!=''">
            <h3><xsl:value-of select="TITRE"/></h3>
        </xsl:if>
        <ul>
            <xsl:apply-templates select="EL"/>
        </ul>
    </xsl:template>
    
    <xsl:template match="EL">
        <li><xsl:apply-templates/></li>
    </xsl:template>
    
    <xsl:template match="LISTEDEF">
        <xsl:if test="normalize-space(TITRE)!=''">
            <h3><xsl:value-of select="TITRE"/></h3>
        </xsl:if>
        <dl>
            <xsl:apply-templates select="TERME | DEF"/>
        </dl>
    </xsl:template>
    
    <xsl:template match="TERME">
        <dt><xsl:apply-templates/></dt>
    </xsl:template>
    
    <xsl:template match="DEF">
        <dd><xsl:apply-templates/></dd>
    </xsl:template>
    
    <xsl:template match="ESP">&#xA0;</xsl:template>
    
    <xsl:template match="BR"><br/></xsl:template>
    
    <xsl:template match="IMAGE">
        <img src="{@fichier}" alt="{@alt}"/>
    </xsl:template>
    
    <xsl:template match="TABLEAU">
        <table border="1" width="100%">
            <xsl:apply-templates/>
        </table>
    </xsl:template>
    
    <xsl:template match="LT">
        <tr><xsl:apply-templates/></tr>
    </xsl:template>
    
    <xsl:template match="ET">
        <th>
            <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
            <xsl:apply-templates/>
        </th>
    </xsl:template>
    
    <xsl:template match="CT">
        <xsl:variable name="ltpos"><xsl:number from="TABLEAU" count="LT"/></xsl:variable>
        <td class="tableau{1+($ltpos mod 2)}">
            <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
            <xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
            <xsl:apply-templates/>
        </td>
    </xsl:template>
    
    <xsl:template match="EQUATION">
        <img class="equation" src="{@image}" alt="{@texte}"/>
    </xsl:template>
    
    <xsl:template match="ENVIMAGE">
        <div align="center"><table border="0" cellspacing="10" class="envimage">
            <xsl:if test="normalize-space(TITRE)!=''">
                <tr><td><div class="titreimage"><xsl:value-of select="TITRE"/></div></td></tr>
            </xsl:if>
            <tr><td><xsl:apply-templates/></td></tr>
        </table></div>
    </xsl:template>
    
    <xsl:template match="LEGENDE">
        <div class="legende">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    <xsl:template match="COMMENTAIRE">
        <xsl:if test="$commentaires='oui'">
            <div class="commentaire">
                <xsl:apply-templates/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="APPLET">
        <applet code="{@classe}" archive="{@archive}" width="{@largeur}" height="{@hauteur}">
            <xsl:apply-templates/>
        </applet>
        <br/>
    </xsl:template>
    
    <xsl:template match="PARAM">
        <param name="{@nom}" value="{@valeur}"/>
    </xsl:template>
    
</xsl:stylesheet>
