/*
 * Decompiled with CFR 0.152.
 */
package xpages.fmsware;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class GifDecoder {
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    protected BufferedInputStream in;
    protected int status;
    protected int width;
    protected int height;
    protected boolean gctFlag;
    protected int gctSize;
    protected int loopCount = -1;
    protected int[] gct;
    protected int[] lct;
    protected int[] act;
    protected int bgIndex;
    protected int bgColor;
    protected int gbgColor;
    protected int lastBgColor;
    protected int pixelAspect;
    protected boolean lctFlag;
    protected boolean interlace;
    protected int lctSize;
    protected int ix;
    protected int iy;
    protected int iw;
    protected int ih;
    protected Rectangle lastRect;
    protected BufferedImage image;
    protected BufferedImage lastImage;
    protected byte[] block = new byte[256];
    protected int blockSize = 0;
    protected int dispose = 0;
    protected int lastDispose = 0;
    protected boolean transparency = false;
    protected int delay = 0;
    protected int transIndex;
    protected static final int MaxStackSize = 4096;
    protected short[] prefix;
    protected byte[] suffix;
    protected byte[] pixelStack;
    protected byte[] pixels;
    protected boolean indexation = false;
    protected ArrayList<GifFrame> frames;
    protected int frameCount;

    public int getDelay(int n) {
        this.delay = -1;
        if (n >= 0 && n < this.frameCount) {
            this.delay = this.frames.get((int)n).delay;
        }
        return this.delay;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public BufferedImage getImage() {
        return this.getFrame(0);
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setIndexation(boolean bl) {
        this.indexation = bl;
    }

    public int[] getGct() {
        return this.gct;
    }

    public int getBgColor() {
        return this.gbgColor;
    }

    protected void setPixels() {
        int n;
        int[] nArray = null;
        byte[] byArray = null;
        if (!this.indexation) {
            nArray = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        } else {
            byArray = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
        }
        if (this.lastDispose > 0) {
            if (this.lastDispose == 3) {
                n = this.frameCount - 2;
                this.lastImage = n > 0 ? this.getFrame(n - 1) : null;
            }
            if (this.lastImage != null) {
                if (!this.indexation) {
                    int[] nArray2 = ((DataBufferInt)this.lastImage.getRaster().getDataBuffer()).getData();
                    System.arraycopy(nArray2, 0, nArray, 0, this.width * this.height);
                } else {
                    byte[] byArray2 = ((DataBufferByte)this.lastImage.getRaster().getDataBuffer()).getData();
                    System.arraycopy(byArray2, 0, byArray, 0, this.width * this.height);
                }
                if (this.lastDispose == 2) {
                    if (this.indexation) {
                        if (this.transparency) {
                            for (int i = 0; i < this.width * this.height; ++i) {
                                byArray[i] = (byte)this.transIndex;
                            }
                        } else {
                            for (int i = 0; i < this.width * this.height; ++i) {
                                byArray[i] = (byte)this.bgIndex;
                            }
                        }
                    } else {
                        Graphics2D graphics2D = this.image.createGraphics();
                        Color color = null;
                        color = this.transparency ? new Color(0, 0, 0, 0) : new Color(this.lastBgColor);
                        graphics2D.setColor(color);
                        graphics2D.setComposite(AlphaComposite.Src);
                        graphics2D.fill(this.lastRect);
                        graphics2D.dispose();
                    }
                }
            }
        }
        n = 1;
        int n2 = 8;
        int n3 = 0;
        for (int i = 0; i < this.ih; ++i) {
            int n4 = i;
            if (this.interlace) {
                if (n3 >= this.ih) {
                    switch (++n) {
                        case 2: {
                            n3 = 4;
                            break;
                        }
                        case 3: {
                            n3 = 2;
                            n2 = 4;
                            break;
                        }
                        case 4: {
                            n3 = 1;
                            n2 = 2;
                        }
                    }
                }
                n4 = n3;
                n3 += n2;
            }
            if ((n4 += this.iy) >= this.height) continue;
            int n5 = n4 * this.width;
            int n6 = n5 + this.ix;
            int n7 = n6 + this.iw;
            if (n5 + this.width < n7) {
                n7 = n5 + this.width;
            }
            int n8 = i * this.iw;
            while (n6 < n7) {
                int n9;
                int n10;
                if (this.indexation) {
                    if ((n10 = (int)((byte)(this.pixels[n8++] & 0xFF))) != this.transIndex || this.lastImage == null) {
                        byArray[n6] = n10;
                    }
                } else if ((n9 = this.act[n10 = this.pixels[n8++] & 0xFF]) != 0) {
                    nArray[n6] = n9;
                }
                ++n6;
            }
        }
    }

    public BufferedImage getFrame(int n) {
        BufferedImage bufferedImage = null;
        if (n >= 0 && n < this.frameCount) {
            bufferedImage = this.frames.get((int)n).image;
        }
        return bufferedImage;
    }

    public Dimension getFrameSize() {
        return new Dimension(this.width, this.height);
    }

    public int read(BufferedInputStream bufferedInputStream) {
        this.init();
        if (bufferedInputStream != null) {
            this.in = bufferedInputStream;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        try {
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.status;
    }

    public int read(InputStream inputStream) {
        this.init();
        if (inputStream != null) {
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            this.in = (BufferedInputStream)inputStream;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.status;
    }

    public int read(String string) {
        this.status = 0;
        try {
            string = string.trim().toLowerCase();
            if (string.indexOf("file:") >= 0 || string.indexOf(":/") > 0) {
                URL uRL = new URL(string);
                this.in = new BufferedInputStream(uRL.openStream());
            } else {
                this.in = new BufferedInputStream(new FileInputStream(string));
            }
            this.status = this.read(this.in);
        }
        catch (IOException iOException) {
            this.status = 2;
        }
        return this.status;
    }

    protected void decodeImageData() {
        int n;
        int n2 = -1;
        int n3 = this.iw * this.ih;
        if (this.pixels == null || this.pixels.length < n3) {
            this.pixels = new byte[n3];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int n4 = this.read();
        int n5 = 1 << n4;
        int n6 = n5 + 1;
        int n7 = n5 + 2;
        int n8 = n2;
        int n9 = n4 + 1;
        int n10 = (1 << n9) - 1;
        for (n = 0; n < n5; ++n) {
            this.prefix[n] = 0;
            this.suffix[n] = (byte)n;
        }
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        while (n18 < n3) {
            if (n13 == 0) {
                if (n16 < n9) {
                    if (n15 == 0) {
                        n15 = this.readBlock();
                        if (n15 <= 0) break;
                        n11 = 0;
                    }
                    n17 += (this.block[n11] & 0xFF) << n16;
                    n16 += 8;
                    ++n11;
                    --n15;
                    continue;
                }
                n = n17 & n10;
                n17 >>= n9;
                n16 -= n9;
                if (n > n7 || n == n6) break;
                if (n == n5) {
                    n9 = n4 + 1;
                    n10 = (1 << n9) - 1;
                    n7 = n5 + 2;
                    n8 = n2;
                    continue;
                }
                if (n8 == n2) {
                    this.pixelStack[n13++] = this.suffix[n];
                    n8 = n;
                    n14 = n;
                    continue;
                }
                int n19 = n;
                if (n == n7) {
                    this.pixelStack[n13++] = (byte)n14;
                    n = n8;
                }
                while (n > n5) {
                    this.pixelStack[n13++] = this.suffix[n];
                    n = this.prefix[n];
                }
                n14 = this.suffix[n] & 0xFF;
                if (n7 >= 4096) break;
                this.pixelStack[n13++] = (byte)n14;
                this.prefix[n7] = (short)n8;
                this.suffix[n7] = (byte)n14;
                if ((++n7 & n10) == 0 && n7 < 4096) {
                    ++n9;
                    n10 += n7;
                }
                n8 = n19;
            }
            this.pixels[n12++] = this.pixelStack[--n13];
            ++n18;
        }
        for (n18 = n12; n18 < n3; ++n18) {
            this.pixels[n18] = 0;
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected void init() {
        this.status = 0;
        this.frameCount = 0;
        this.frames = new ArrayList();
        this.gct = null;
        this.lct = null;
    }

    protected int read() {
        int n = 0;
        try {
            n = this.in.read();
        }
        catch (IOException iOException) {
            this.status = 1;
        }
        return n;
    }

    protected int readBlock() {
        int n;
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            try {
                int n2 = 0;
                for (n = 0; n < this.blockSize && (n2 = this.in.read(this.block, n, this.blockSize - n)) != -1; n += n2) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n < this.blockSize) {
                this.status = 1;
            }
        }
        return n;
    }

    protected int[] readColorTable(int n) {
        int n2 = 3 * n;
        int[] nArray = null;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = this.in.read(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n3 < n2) {
            this.status = 1;
        } else {
            nArray = new int[256];
            int n4 = 0;
            int n5 = 0;
            while (n4 < n) {
                int n6 = byArray[n5++] & 0xFF;
                int n7 = byArray[n5++] & 0xFF;
                int n8 = byArray[n5++] & 0xFF;
                nArray[n4++] = 0xFF000000 | n6 << 16 | n7 << 8 | n8;
            }
        }
        return nArray;
    }

    protected void readContents() {
        boolean bl = false;
        while (!bl && !this.err()) {
            int n = this.read();
            block0 : switch (n) {
                case 44: {
                    this.readImage();
                    break;
                }
                case 33: {
                    n = this.read();
                    switch (n) {
                        case 249: {
                            this.readGraphicControlExt();
                            break block0;
                        }
                        case 255: {
                            this.readBlock();
                            String string = "";
                            for (int i = 0; i < 11; ++i) {
                                string = string + (char)this.block[i];
                            }
                            if (string.equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                break block0;
                            }
                            this.skip();
                            break block0;
                        }
                    }
                    this.skip();
                    break;
                }
                case 59: {
                    bl = true;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    this.status = 1;
                }
            }
        }
    }

    protected void readGraphicControlExt() {
        this.read();
        int n = this.read();
        this.dispose = (n & 0x1C) >> 2;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.transparency = (n & 1) != 0;
        this.delay = this.readShort() * 10;
        this.transIndex = this.read();
        this.read();
    }

    protected void readHeader() {
        String string = "";
        for (int i = 0; i < 6; ++i) {
            string = string + (char)this.read();
        }
        if (!string.startsWith("GIF")) {
            this.status = 1;
            return;
        }
        this.readLSD();
        if (this.gctFlag && !this.err()) {
            this.gct = this.readColorTable(this.gctSize);
            this.gbgColor = this.bgColor = this.gct[this.bgIndex];
        }
    }

    protected void readImage() {
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int n = this.read();
        this.lctFlag = (n & 0x80) != 0;
        this.interlace = (n & 0x40) != 0;
        this.lctSize = 2 << (n & 7);
        if (this.lctFlag) {
            this.lct = this.readColorTable(this.lctSize);
            this.act = this.lct;
        } else {
            this.act = this.gct;
            if (this.bgIndex == this.transIndex) {
                this.bgColor = 0;
            }
        }
        int n2 = 0;
        if (this.transparency) {
            n2 = this.act[this.transIndex];
            this.act[this.transIndex] = 0;
        }
        if (this.act == null) {
            this.status = 1;
        }
        if (this.err()) {
            return;
        }
        this.decodeImageData();
        this.skip();
        if (this.err()) {
            return;
        }
        ++this.frameCount;
        if (this.indexation) {
            if (this.transparency) {
                this.act[this.transIndex] = n2;
            }
            IndexColorModel indexColorModel = new IndexColorModel(8, this.act.length, this.act, 0, this.transparency, this.transparency ? this.transIndex : -1, 0);
            if (this.transparency) {
                this.act[this.transIndex] = 0;
            }
            this.image = new BufferedImage(this.width, this.height, 13, indexColorModel);
        } else {
            this.image = new BufferedImage(this.width, this.height, 3);
        }
        this.setPixels();
        this.frames.add(new GifFrame(this.image, this.delay));
        if (this.transparency) {
            this.act[this.transIndex] = n2;
        }
        this.resetFrame();
    }

    protected void readLSD() {
        this.width = this.readShort();
        this.height = this.readShort();
        int n = this.read();
        this.gctFlag = (n & 0x80) != 0;
        this.gctSize = 2 << (n & 7);
        this.bgIndex = this.read();
        this.pixelAspect = this.read();
    }

    protected void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int n = this.block[1] & 0xFF;
            int n2 = this.block[2] & 0xFF;
            this.loopCount = n2 << 8 | n;
        } while (this.blockSize > 0 && !this.err());
    }

    protected int readShort() {
        return this.read() | this.read() << 8;
    }

    protected void resetFrame() {
        this.lastDispose = this.dispose;
        this.lastRect = new Rectangle(this.ix, this.iy, this.iw, this.ih);
        this.lastImage = this.image;
        this.lastBgColor = this.bgColor;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.lct = null;
    }

    protected void skip() {
        do {
            this.readBlock();
        } while (this.blockSize > 0 && !this.err());
    }

    static class GifFrame {
        public BufferedImage image;
        public int delay;

        public GifFrame(BufferedImage bufferedImage, int n) {
            this.image = bufferedImage;
            this.delay = n;
        }
    }
}

