/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.print;

import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.java2d.Java2DRenderer;

public class PrintRenderer
extends Java2DRenderer
implements Pageable {
    private static final int EVEN_AND_ALL = 0;
    private static final int EVEN = 1;
    private static final int ODD = 2;
    private int startNumber = 0;
    private int endNumber = -1;
    private int mode = 0;
    private int copies = 1;
    private PrinterJob printerJob;

    public PrintRenderer() {
        this.initializePrinterJob();
    }

    public PrintRenderer(PrinterJob printerJob) {
        this.printerJob = printerJob;
        printerJob.setPageable(this);
    }

    private void initializePrinterJob() throws IllegalArgumentException {
        this.copies = PrintRenderer.getIntProperty("copies", 1);
        this.startNumber = PrintRenderer.getIntProperty("start", 1) - 1;
        this.endNumber = PrintRenderer.getIntProperty("end", -1);
        String str = System.getProperty("even");
        if (str != null) {
            this.mode = Boolean.valueOf(str) != false ? 1 : 2;
        }
        this.printerJob = PrinterJob.getPrinterJob();
        this.printerJob.setJobName("FOP Document");
        this.printerJob.setCopies(this.copies);
        if (System.getProperty("dialog") != null && !this.printerJob.printDialog()) {
            throw new IllegalArgumentException("Printing cancelled by operator");
        }
        this.printerJob.setPageable(this);
    }

    public PrinterJob getPrinterJob() {
        return this.printerJob;
    }

    public int getEndNumber() {
        return this.endNumber;
    }

    public void setEndPage(int end) {
        this.endNumber = end;
    }

    public int getStartPage() {
        return this.startNumber;
    }

    public void setStartPage(int start) {
        this.startNumber = start;
    }

    public void stopRenderer() throws IOException {
        super.stopRenderer();
        if (this.endNumber == -1) {
            this.endNumber = this.getNumberOfPages();
        }
        Vector numbers = this.getInvalidPageNumbers();
        for (int i = numbers.size() - 1; i > -1; --i) {
        }
        try {
            this.printerJob.print();
        }
        catch (PrinterException e) {
            log.error(e);
            throw new IOException("Unable to print: " + e.getClass().getName() + ": " + e.getMessage());
        }
        this.clearViewportList();
    }

    public static int getIntProperty(String name, int def) {
        String propValue = System.getProperty(name);
        if (propValue != null) {
            try {
                return Integer.parseInt(propValue);
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    private Vector getInvalidPageNumbers() {
        Vector<String> vec = new Vector<String>();
        int max = this.getNumberOfPages();
        for (int i = 0; i < max; ++i) {
            boolean isValid = true;
            if (i < this.startNumber || i > this.endNumber) {
                isValid = false;
            } else if (this.mode != 0) {
                if (this.mode == 1 && (i + 1) % 2 != 0) {
                    isValid = false;
                } else if (this.mode == 2 && (i + 1) % 2 != 1) {
                    isValid = false;
                }
            }
            if (isValid) continue;
            vec.add(Integer.toString(i));
        }
        return vec;
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        try {
            double height;
            if (pageIndex >= this.getNumberOfPages()) {
                return null;
            }
            PageFormat pageFormat = new PageFormat();
            Paper paper = new Paper();
            Rectangle2D dim = this.getPageViewport(pageIndex).getViewArea();
            double width = dim.getWidth();
            if (width > (height = dim.getHeight())) {
                paper.setImageableArea(0.0, 0.0, height / 1000.0, width / 1000.0);
                paper.setSize(height / 1000.0, width / 1000.0);
                pageFormat.setOrientation(0);
            } else {
                paper.setImageableArea(0.0, 0.0, width / 1000.0, height / 1000.0);
                paper.setSize(width / 1000.0, height / 1000.0);
                pageFormat.setOrientation(1);
            }
            pageFormat.setPaper(paper);
            return pageFormat;
        }
        catch (FOPException fopEx) {
            throw new IndexOutOfBoundsException(fopEx.getMessage());
        }
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }
}

