/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.fop.pdf.PDFObject;

public class PDFNumber
extends PDFObject {
    private Number number;
    private static DecimalFormat[] decimalFormatCache = new DecimalFormat[17];
    private static final String BASE_FORMAT = "0.################";

    public Number getNumber() {
        return this.number;
    }

    public void setNumber(Number number) {
        this.number = number;
    }

    public static String doubleOut(Double doubleDown) {
        return PDFNumber.doubleOut((double)doubleDown);
    }

    public static String doubleOut(double doubleDown) {
        return PDFNumber.doubleOut(doubleDown, 6);
    }

    public static String doubleOut(double doubleDown, int dec) {
        if (dec < 0 || dec >= decimalFormatCache.length) {
            throw new IllegalArgumentException("Parameter dec must be between 1 and " + (decimalFormatCache.length + 1));
        }
        if (decimalFormatCache[dec] == null) {
            DecimalFormat df;
            String s = "0";
            if (dec > 0) {
                s = BASE_FORMAT.substring(0, dec + 2);
            }
            PDFNumber.decimalFormatCache[dec] = df = new DecimalFormat(s, new DecimalFormatSymbols(Locale.US));
        }
        return decimalFormatCache[dec].format(doubleDown);
    }

    protected String toPDFString() {
        if (this.getNumber() == null) {
            throw new IllegalArgumentException("The number of this PDFNumber must not be empty");
        }
        StringBuffer sb = new StringBuffer(64);
        if (this.hasObjectNumber()) {
            sb.append(this.getObjectID());
        }
        sb.append(this.getNumber().toString());
        if (this.hasObjectNumber()) {
            sb.append("\nendobj\n");
        }
        return sb.toString();
    }
}

