/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.traits.MinOptMax;

public class BalancingColumnBreakingAlgorithm
extends PageBreakingAlgorithm {
    private Log log = LogFactory.getLog(BalancingColumnBreakingAlgorithm.class);
    private int columnCount;
    private int fullLen;
    private int idealPartLen;

    public BalancingColumnBreakingAlgorithm(LayoutManager topLevelLM, PageProvider pageProvider, PageBreakingAlgorithm.PageBreakingLayoutListener layoutListener, int alignment, int alignmentLast, MinOptMax footnoteSeparatorLength, boolean partOverflowRecovery, int columnCount) {
        super(topLevelLM, pageProvider, layoutListener, alignment, alignmentLast, footnoteSeparatorLength, partOverflowRecovery, false, false);
        this.columnCount = columnCount;
        this.considerTooShort = true;
    }

    protected double computeDemerits(BreakingAlgorithm.KnuthNode activeNode, KnuthElement element, int fitnessClass, double r) {
        double absBalance;
        double dem = super.computeDemerits(activeNode, element, fitnessClass, r);
        if (this.log.isTraceEnabled()) {
            this.log.trace("original demerit=" + dem + " " + this.totalWidth + " line=" + activeNode.line + "/" + this.columnCount + " pos=" + activeNode.position + "/" + (this.par.size() - 1));
        }
        int remParts = this.columnCount - activeNode.line;
        int curPos = this.par.indexOf(element);
        if (this.fullLen == 0) {
            this.fullLen = ElementListUtils.calcContentLength(this.par, activeNode.position, this.par.size() - 1);
            this.idealPartLen = this.fullLen / this.columnCount;
        }
        int partLen = ElementListUtils.calcContentLength(this.par, activeNode.position, curPos - 1);
        int restLen = ElementListUtils.calcContentLength(this.par, curPos - 1, this.par.size() - 1);
        int avgRestLen = 0;
        if (remParts > 0) {
            avgRestLen = restLen / remParts;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("remaining parts: " + remParts + " rest len: " + restLen + " avg=" + avgRestLen);
        }
        double balance = (float)(this.idealPartLen - partLen) / 1000.0f;
        if (this.log.isTraceEnabled()) {
            this.log.trace("balance=" + balance);
        }
        dem = absBalance = Math.abs(balance);
        if (this.columnCount > 2) {
            if (balance > 0.0) {
                dem *= (double)1.2f;
            }
        } else if (balance < 0.0) {
            dem *= (double)1.2f;
        }
        dem += (double)((float)avgRestLen / 1000.0f);
        if (activeNode.line >= this.columnCount) {
            dem = Double.MAX_VALUE;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("effective dem=" + dem + " " + this.totalWidth);
        }
        return dem;
    }
}

