/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import jaxe.DocumentRenderer;
import jaxe.JaxeDocument;
import jaxe.JaxeFrame;
import jaxe.JaxeMenuBar;
import jaxe.JaxeResourceBundle;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ValidationFrame
extends JFrame
implements MouseListener,
ActionListener {
    private static final Logger LOG = Logger.getLogger(ValidationFrame.class);
    JaxeDocument doc;
    JaxeFrame jframe;
    JEditorPane editorPane;
    String contenu;
    ArrayList<Erreur> erreurs;

    public ValidationFrame(JaxeDocument jaxeDocument, JaxeFrame jaxeFrame) {
        super(JaxeResourceBundle.getRB().getString("validation.Validation"));
        this.jframe = jaxeFrame;
        JaxeMenuBar jaxeMenuBar = new JaxeMenuBar(this, jaxeFrame);
        this.setJMenuBar(jaxeMenuBar);
        this.newdoc(jaxeDocument);
    }

    public void newdoc(JaxeDocument jaxeDocument) {
        this.doc = jaxeDocument;
        if (jaxeDocument.cfg == null) {
            JOptionPane.showMessageDialog(this.jframe, JaxeResourceBundle.getRB().getString("validation.Schema"), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
            return;
        }
        Rectangle rectangle = this.jframe.getBounds();
        this.setLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        this.setSize(new Dimension(620, 460));
        this.affichage();
        this.miseAJour();
    }

    protected void affichage() {
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.editorPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton(JaxeResourceBundle.getRB().getString("validation.MiseAJour"));
        jButton.addActionListener(this);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "North");
        this.setContentPane(jPanel2);
        this.editorPane.addMouseListener(this);
    }

    protected void print(String string) {
        this.contenu = this.contenu + string;
    }

    protected void println(String string) {
        this.contenu = this.contenu + string + "\n";
    }

    public void miseAJour() {
        if (this.doc.cfg.schemaURL == null) {
            return;
        }
        this.contenu = "";
        this.erreurs = new ArrayList();
        boolean[] blArray = new boolean[1];
        try {
            Document document = (Document)this.doc.DOMdoc.cloneNode(true);
            DOMConfiguration dOMConfiguration = document.getDomConfig();
            dOMConfiguration.setParameter("schema-type", "http://www.w3.org/2001/XMLSchema");
            dOMConfiguration.setParameter("schema-location", this.doc.cfg.schemaURL.toURI().toString());
            dOMConfiguration.setParameter("validate", Boolean.TRUE);
            blArray[0] = false;
            ErrorStorer errorStorer = new ErrorStorer(blArray);
            dOMConfiguration.setParameter("error-handler", errorStorer);
            document.normalizeDocument();
        }
        catch (Exception exception) {
            LOG.error("miseAJour()", exception);
            blArray[0] = true;
            this.print(exception.getMessage());
        }
        if (!blArray[0]) {
            this.print(JaxeResourceBundle.getRB().getString("validation.parfait"));
        }
        this.editorPane.setText(this.contenu);
        this.setVisible(true);
        this.editorPane.repaint();
    }

    protected Node chercherOriginal(Node node) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Node node2 = node;
        while (node2.getNodeType() != 9) {
            n = 0;
            for (Node node3 = node2.getPreviousSibling(); node3 != null; node3 = node3.getPreviousSibling()) {
                ++n;
            }
            arrayList.add(n);
            node2 = node2.getParentNode();
        }
        node2 = this.doc.DOMdoc;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            if ((node2 = node2.getFirstChild()) == null) {
                LOG.error("ValidationFrame.chercherOriginal : impossible de retrouver le noeud d'origine (1)");
                LOG.error("numeros: " + arrayList);
                return null;
            }
            n = (Integer)arrayList.get(i);
            for (int j = 0; j < n; ++j) {
                if (node2 == null) {
                    LOG.error("ValidationFrame.chercherOriginal : impossible de retrouver le noeud d'origine (2)");
                    LOG.error("numeros: " + arrayList);
                    return null;
                }
                node2 = node2.getNextSibling();
            }
        }
        return node2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.miseAJour();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.editorPane.viewToModel(mouseEvent.getPoint());
        int n2 = 0;
        int n3 = 0;
        Node node = null;
        for (Erreur erreur : this.erreurs) {
            if (erreur.p1 > n) {
                n3 = erreur.p1;
                break;
            }
            n2 = erreur.p1;
            node = erreur.noeud;
        }
        if (node == null) {
            return;
        }
        if (n3 == 0) {
            n3 = this.contenu.length();
        }
        this.editorPane.setCaretPosition(n2);
        this.editorPane.moveCaretPosition(n3);
        if (node.getNodeType() != 1) {
            return;
        }
        final Element element = (Element)node;
        this.doc.textPane.selectElement(element);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ValidationFrame.this.doc.textPane.allerElement(element);
            }
        });
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void imprimer() {
        DocumentRenderer documentRenderer = new DocumentRenderer();
        documentRenderer.print(this.editorPane);
    }

    class Erreur {
        public Node noeud;
        public int ligne;
        public int p1;

        public Erreur(Node node, int n, int n2) {
            this.noeud = node;
            this.ligne = n;
            this.p1 = n2;
        }
    }

    class ErrorStorer
    implements DOMErrorHandler {
        boolean[] terreur;

        public ErrorStorer(boolean[] blArray) {
            this.terreur = blArray;
        }

        public boolean handleError(DOMError dOMError) {
            String string;
            DOMLocator dOMLocator = dOMError.getLocation();
            ValidationFrame.this.erreurs.add(new Erreur(ValidationFrame.this.chercherOriginal(dOMLocator.getRelatedNode()), dOMLocator.getLineNumber(), ValidationFrame.this.contenu.length()));
            this.terreur[0] = true;
            switch (dOMError.getSeverity()) {
                case 1: {
                    string = "Warning";
                    break;
                }
                case 2: {
                    string = "Error";
                    break;
                }
                case 3: {
                    string = "Fatal Error";
                    break;
                }
                default: {
                    string = "?";
                }
            }
            ValidationFrame.this.print(string);
            if (dOMLocator.getLineNumber() != -1) {
                ValidationFrame.this.println("  at line number " + dOMLocator.getLineNumber());
            }
            ValidationFrame.this.println(" : " + dOMError.getMessage() + "\n");
            return true;
        }
    }
}

