/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import jaxe.Config;
import jaxe.ImageKeeper;
import jaxe.JEFactory;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import jaxe.SchemaW3C;
import jaxe.elements.JECData;
import jaxe.elements.JECommentaire;
import jaxe.elements.JEInconnu;
import jaxe.elements.JEStyle;
import jaxe.elements.JESwing;
import jaxe.elements.JETableTexte;
import jaxe.elements.JETexte;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxeElement {
    private static final Pattern COLOR_PATTERN = Pattern.compile("^.*\\[(x[0-9a-fA-F]{2}|[0-9]{1,3}),(x[0-9a-fA-F]{2}|[0-9]{1,3}),(x[0-9a-fA-F]{2}|[0-9]{1,3})\\]$");
    private static final Logger LOG = Logger.getLogger(JaxeElement.class);
    protected static ImageIcon iconeAttributs = new ImageIcon(ImageKeeper.loadImage("images/attributs.gif", true));
    protected static ImageIcon iconeValide = new ImageIcon(ImageKeeper.loadImage("images/valide.gif", true));
    protected static ImageIcon iconeInvalide = new ImageIcon(ImageKeeper.loadImage("images/invalide.gif", true));
    public static final String kGras = "GRAS";
    public static final String kItalique = "ITALIQUE";
    public static final String kExposant = "EXPOSANT";
    public static final String kCouleur = "PCOULEUR";
    public static final String kCouleurDeFond = "FCOULEUR";
    public static final String kIndice = "INDICE";
    public static final String kSouligne = "SOULIGNE";
    public static final String kBarre = "BARRE";
    public Position debut = null;
    public Position fin = null;
    public Node noeud;
    public Element refElement = null;
    public JaxeDocument doc;
    public ArrayList<Object> jcomps = new ArrayList();
    public ArrayList<Position> compos = new ArrayList();
    private boolean effacementAutorise = true;
    private boolean editionAutorisee = true;
    static Font boutonFont = (Font)UIManager.getDefaults().get("Button.font");
    static final Color jauneLeger = new Color(250, 250, 180);
    static final Color rougeFonce = new Color(150, 0, 0);
    static final Color orange = new Color(255, 210, 170);
    static final Color bleuClair = new Color(220, 240, 250);
    static final Color violet = new Color(220, 210, 255);
    static final Color vertClair = new Color(210, 250, 220);
    static final Color vertJaune = new Color(230, 250, 180);
    static Color[][] couleursButtons = new Color[][]{{jauneLeger, rougeFonce, orange}, {bleuClair, rougeFonce, violet}, {vertClair, rougeFonce, vertJaune}};
    static Border boutonBorder = null;

    public abstract void init(Position var1, Node var2);

    public void creer(Position position, Node node) {
        this.noeud = node;
        this.doc.dom2JaxeElement.put(node, this);
        if (this.doc.cfg != null) {
            String string;
            HashMap<String, ArrayList<String>> hashMap;
            String string2 = node.getNodeName();
            if (node.getNodeType() == 1) {
                if (this.refElement == null) {
                    hashMap = node.getParentNode();
                    this.refElement = hashMap != null ? this.doc.cfg.getElementRef((Element)node, this.doc.getElementForNode((Node)((Object)hashMap)).refElement) : this.doc.cfg.getElementRef((Element)node, null);
                }
                string = "element";
            } else {
                string = node.getNodeType() == 7 ? "instruction" : (node.getNodeType() == 8 ? "commentaire" : (node.getNodeType() == 4 ? "cdata" : null));
            }
            if (this.refElement != null || node.getNodeType() == 7) {
                hashMap = this.doc.cfg.getParametresNoeud(this.refElement, string, string2);
                ArrayList arrayList = (ArrayList)hashMap.get("effacementAutorise");
                String string3 = arrayList != null && arrayList.size() > 0 ? (String)arrayList.get(0) : null;
                ArrayList arrayList2 = (ArrayList)hashMap.get("editionAutorisee");
                String string4 = arrayList2 != null && arrayList2.size() > 0 ? (String)arrayList2.get(0) : null;
                this.effacementAutorise = !"false".equals(string3);
                this.editionAutorisee = !"false".equals(string4);
            }
        }
        this.init(position, node);
        this.majValidite();
    }

    public abstract Node nouvelElement(Element var1);

    public void afficherDialogue(JFrame jFrame) {
    }

    public void majAffichage() {
    }

    public void majValidite() {
    }

    public ArrayList<Object> getComponents() {
        return this.jcomps;
    }

    public ArrayList<Position> getComponentPositions() {
        return this.compos;
    }

    public Position insertText(Position position, String string, AttributeSet attributeSet) {
        try {
            int n = position.getOffset();
            this.doc.insertString(position.getOffset(), string, attributeSet);
            if (this.debut == null) {
                this.debut = this.doc.createPosition(n);
            }
            if (position.getOffset() == 0) {
                position = this.doc.createPosition(1);
            }
            this.fin = this.doc.createPosition(position.getOffset() - 1);
        }
        catch (BadLocationException badLocationException) {
            LOG.error("insertText(Position, String, AttributeSet) - BadLocationException: " + badLocationException.getMessage(), badLocationException);
        }
        return position;
    }

    public Position insertText(Position position, String string) {
        Node node;
        SimpleAttributeSet simpleAttributeSet = null;
        JaxeElement jaxeElement = this.debut == null ? ((node = this.noeud.getParentNode()) != null ? this.doc.getElementForNode(node) : null) : this;
        if (jaxeElement != null) {
            if (jaxeElement.debut.getOffset() == position.getOffset() && !(jaxeElement instanceof JESwing)) {
                jaxeElement = jaxeElement.getParent();
            }
            if (jaxeElement != null) {
                simpleAttributeSet = jaxeElement.attStyle(null);
            }
        }
        return this.insertText(position, string, simpleAttributeSet);
    }

    public Position insertComponent(Position position, JComponent jComponent) {
        int n = position.getOffset();
        Style style = this.doc.textPane.addStyle(null, null);
        StyleConstants.setComponent(style, jComponent);
        try {
            this.doc.insertString(position.getOffset(), "*", style, false);
            this.jcomps.add(jComponent);
            this.compos.add(this.doc.createPosition(position.getOffset() - 1));
            if (this.debut == null) {
                this.debut = this.doc.createPosition(n);
            }
            this.fin = this.doc.createPosition(n);
            if (position.getOffset() == 0) {
                position = this.doc.createPosition(1);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.error("insertComponent(Position, JComponent) - BadLocationException: " + badLocationException.getMessage(), badLocationException);
        }
        return position;
    }

    public Position insertIcon(Position position, Icon icon) {
        int n = position.getOffset();
        Style style = this.doc.textPane.addStyle(null, null);
        StyleConstants.setIcon(style, icon);
        try {
            this.doc.insertString(position.getOffset(), "*", style, false);
            this.jcomps.add(icon);
            this.compos.add(this.doc.createPosition(position.getOffset() - 1));
            if (this.debut == null) {
                this.debut = this.doc.createPosition(n);
            }
            this.fin = this.doc.createPosition(n);
            if (position.getOffset() == 0) {
                position = this.doc.createPosition(1);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.error("insertIcon(Position, Icon) - BadLocationException: " + badLocationException.getMessage(), badLocationException);
        }
        return position;
    }

    public JaxeElement elementA(int n) {
        if (this.debut == null || this.fin == null) {
            return null;
        }
        if (this.debut.getOffset() > n || this.fin.getOffset() < n) {
            return null;
        }
        for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            JaxeElement jaxeElement;
            JaxeElement jaxeElement2;
            short s = node.getNodeType();
            if (s != 1 && s != 3 && s != 7 && s != 8 && s != 4 || (jaxeElement2 = this.doc.getElementForNode(node)) == null || (jaxeElement = jaxeElement2.elementA(n)) == null) continue;
            return jaxeElement;
        }
        return this;
    }

    public ArrayList<JaxeElement> elementsDans(int n, int n2) {
        ArrayList<JaxeElement> arrayList = new ArrayList<JaxeElement>();
        if (this.debut == null || this.fin == null) {
            return arrayList;
        }
        if (this.debut.getOffset() > n2 || this.fin.getOffset() < n) {
            return arrayList;
        }
        if (this.debut.getOffset() >= n && (this.fin.getOffset() <= n2 || this instanceof JESwing && this.fin.getOffset() == n2 + 1)) {
            arrayList.add(this);
        } else {
            for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
                JaxeElement jaxeElement;
                short s = node.getNodeType();
                if (s != 1 && s != 3 && s != 7 && s != 8 && s != 4 || (jaxeElement = this.doc.getElementForNode(node)) == null) continue;
                arrayList.addAll(jaxeElement.elementsDans(n, n2));
            }
        }
        return arrayList;
    }

    public int nombreXPath() {
        JaxeElement jaxeElement = this.getParent();
        if (jaxeElement == null) {
            return 0;
        }
        int n = 0;
        String string = this.noeud.getNodeName();
        for (Node node = jaxeElement.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (string.equals(node.getNodeName())) {
                ++n;
            }
            if (node == this.noeud) break;
        }
        return n;
    }

    public String cheminA(int n) {
        Object object;
        if (this.debut == null || this.fin == null) {
            return null;
        }
        if (this.debut.getOffset() > n || this.fin.getOffset() < n) {
            return null;
        }
        if (this.noeud.getNodeType() == 3) {
            return "texte";
        }
        if (this.noeud.getNodeType() == 8) {
            return "commentaire";
        }
        if (this.noeud.getNodeType() == 4) {
            return "cdata";
        }
        if (this.noeud.getNodeType() != 1) {
            return null;
        }
        Element element = (Element)this.noeud;
        StringBuilder stringBuilder = new StringBuilder(element.getTagName());
        if (this instanceof JEStyle) {
            stringBuilder.setLength(0);
            object = ((JEStyle)this)._styles.iterator();
            while (object.hasNext()) {
                Element element2 = (Element)object.next();
                if (this.getParent() != null) {
                    stringBuilder.append(element2.getNodeName());
                    stringBuilder.append("[");
                    stringBuilder.append(this.nombreXPath());
                    stringBuilder.append("]");
                }
                if (object.hasNext()) {
                    stringBuilder.append("/");
                    continue;
                }
                element = element2;
            }
        } else if (this.getParent() != null) {
            stringBuilder.append("[");
            stringBuilder.append(this.nombreXPath());
            stringBuilder.append("]");
        }
        for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
            String string;
            JaxeElement jaxeElement;
            short s = object.getNodeType();
            if (s != 1 && s != 3 && s != 7 && s != 8 && s != 4 || (jaxeElement = this.doc.getElementForNode((Node)object)) == null || (string = jaxeElement.cheminA(n)) == null) continue;
            return stringBuilder.append("/").append(string).toString();
        }
        return stringBuilder.toString();
    }

    public JaxeElement enfantApres(int n) {
        if (this.debut == null || this.fin == null) {
            return null;
        }
        if (this.debut.getOffset() > n || this.fin.getOffset() < n) {
            return null;
        }
        for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            JaxeElement jaxeElement;
            short s = node.getNodeType();
            if (s != 1 && s != 3 && s != 7 && s != 8 && s != 4 || (jaxeElement = this.doc.getElementForNode(node)) == null) continue;
            if (jaxeElement.debut.getOffset() == n) {
                return jaxeElement;
            }
            JaxeElement jaxeElement2 = jaxeElement.elementA(n);
            if (jaxeElement2 == null || node.getNextSibling() == null) continue;
            return this.doc.getElementForNode(node.getNextSibling());
        }
        return null;
    }

    public void effacer() {
        Object object;
        for (Object object2 = this.noeud.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            short s = object2.getNodeType();
            if (s != 1 && s != 3 && s != 7 && s != 8 && s != 4 || (object = this.doc.getElementForNode((Node)object2)) == null) continue;
            ((JaxeElement)object).effacer();
        }
        for (Object e : this.jcomps) {
            if (!(e instanceof JComponent) || ((JComponent)e).getParent() == null) continue;
            object = (JComponent)e;
            ((Component)object).getParent().remove((Component)object);
        }
        this.jcomps = new ArrayList();
        this.compos = new ArrayList();
    }

    public void mettreAJourDOM() {
        if (this.debut == null || this.fin == null) {
            return;
        }
        try {
            if (this instanceof JECommentaire || this instanceof JECData) {
                String string = this.doc.getText(this.debut.getOffset() + 1, this.fin.getOffset() - this.debut.getOffset() - 1);
                this.noeud.setNodeValue(string);
            } else if (this.noeud.getNodeType() == 3 || this instanceof JEStyle) {
                Object object;
                Node node = this.noeud.getNextSibling();
                if (node != null && (object = this.doc.getElementForNode(node)) != null && ((JaxeElement)object).debut.getOffset() > this.fin.getOffset() + 1) {
                    this.fin = this.doc.createPosition(((JaxeElement)object).debut.getOffset() - 1);
                }
                if ((object = this.doc.getText(this.debut.getOffset(), this.fin.getOffset() - this.debut.getOffset() + 1)) == null || "".equals(object)) {
                    this.getParent().supprimerEnfant(this);
                } else if (this.noeud.getNodeType() == 3) {
                    this.noeud.setNodeValue((String)object);
                } else {
                    Node node2;
                    for (node2 = this.noeud; node2 != null && node2.getNodeType() != 3; node2 = node2.getFirstChild()) {
                    }
                    if (node2 != null) {
                        node2.setNodeValue((String)object);
                    }
                }
            } else {
                JaxeElement jaxeElement;
                Object object;
                Object object2;
                int n = this.debut.getOffset();
                int n2 = this instanceof JESwing ? n : n + 1;
                for (object2 = this.noeud.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    object = this.doc.getElementForNode((Node)object2);
                    if (object == null) continue;
                    if (n2 < ((JaxeElement)object).debut.getOffset()) {
                        jaxeElement = null;
                        if (object2.getPreviousSibling() != null) {
                            jaxeElement = this.doc.getElementForNode(object2.getPreviousSibling());
                        }
                        if (jaxeElement != null && (jaxeElement instanceof JEStyle || jaxeElement instanceof JETexte)) {
                            jaxeElement.fin = this.doc.createPosition(((JaxeElement)object).debut.getOffset() - 1);
                        } else if (object instanceof JETexte) {
                            ((JaxeElement)object).debut = this.doc.createPosition(n2);
                        } else {
                            String string = this.doc.getText(n2, ((JaxeElement)object).debut.getOffset() - n2);
                            JETexte jETexte = JETexte.nouveau(this.doc, this.doc.createPosition(n2), this.doc.createPosition(((JaxeElement)object).debut.getOffset() - 1), string);
                            this.noeud.insertBefore(jETexte.noeud, (Node)object2);
                        }
                    }
                    n = ((JaxeElement)object).fin.getOffset();
                    n2 = n + 1;
                }
                if (n2 < this.fin.getOffset()) {
                    object2 = null;
                    if (this.noeud.getLastChild() != null) {
                        object2 = this.doc.getElementForNode(this.noeud.getLastChild());
                    }
                    if (object2 instanceof JEStyle || object2 instanceof JETexte) {
                        ((JaxeElement)object2).fin = this.doc.createPosition(this.fin.getOffset() - 1);
                    } else {
                        object = this.doc.getText(n2, this.fin.getOffset() - n2);
                        jaxeElement = JETexte.nouveau(this.doc, this.doc.createPosition(n2), this.doc.createPosition(this.fin.getOffset() - 1), (String)object);
                        this.noeud.appendChild(((JETexte)jaxeElement).noeud);
                    }
                }
                for (object2 = this.noeud.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    object = this.doc.getElementForNode((Node)object2);
                    if (object == null) continue;
                    ((JaxeElement)object).mettreAJourDOM();
                }
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.error("mettreAJourDOM()" + badLocationException.getMessage(), badLocationException);
        }
    }

    @Deprecated
    public static Node nouvelElementDOM(JaxeDocument jaxeDocument, String string, String string2) {
        Node node;
        if (string.equals("instruction")) {
            node = jaxeDocument.DOMdoc.createProcessingInstruction(string2, "");
        } else if (jaxeDocument.cfg.namespace() == null) {
            node = jaxeDocument.DOMdoc.createElementNS(null, string2);
        } else {
            Config config = jaxeDocument.cfg.getBaliseConf(string2);
            if (config == null) {
                config = jaxeDocument.cfg;
            }
            if (config.prefixe() != null) {
                string2 = config.prefixe() + ":" + string2;
            }
            node = jaxeDocument.DOMdoc.createElementNS(config.namespace(), string2);
        }
        return node;
    }

    public static Element nouvelElementDOM(JaxeDocument jaxeDocument, Element element) {
        Element element2;
        if ("BALISE".equals(element.getNodeName()) && jaxeDocument.cfg.getSchema() instanceof SchemaW3C) {
            LOG.error("nouvelElementDOM utilis\u00e9 avec un \u00e9l\u00e9ment du fichier de config au lieu d'un \u00e9l\u00e9ment du sch\u00e9ma");
            return JaxeElement.nouvelElementDOM(jaxeDocument, jaxeDocument.cfg.referenceElement(element.getAttribute("nom")));
        }
        String string = jaxeDocument.cfg.nomElement(element);
        String string2 = jaxeDocument.cfg.espaceElement(element);
        if (string2 == null || "".equals(string2)) {
            element2 = jaxeDocument.DOMdoc.createElementNS(null, string);
        } else {
            String string3 = jaxeDocument.cfg.prefixeElement(element);
            if (string3 != null) {
                string = string3 + ":" + string;
            }
            element2 = jaxeDocument.DOMdoc.createElementNS(string2, string);
        }
        return element2;
    }

    public static ProcessingInstruction nouvelleInstructionDOM(JaxeDocument jaxeDocument, String string) {
        ProcessingInstruction processingInstruction = jaxeDocument.DOMdoc.createProcessingInstruction(string, "");
        return processingInstruction;
    }

    public static Element nouvelElementDOM(JaxeDocument jaxeDocument, String string, Element element) {
        String string2 = element.getNamespaceURI();
        String string3 = element.getPrefix();
        String string4 = string3 != null ? string3 + ':' + string : string;
        return jaxeDocument.DOMdoc.createElementNS(string2, string4);
    }

    public void inserer(Position position, Node node) {
        this.doc.textPane.debutIgnorerEdition();
        this.insererDOM(position, node);
        this.creer(position, node);
        this.doc.textPane.finIgnorerEdition();
        JaxeElement jaxeElement = this.getParent();
        while (jaxeElement instanceof JESwing && jaxeElement.debut.getOffset() > this.debut.getOffset()) {
            jaxeElement.debut = this.debut;
            jaxeElement = jaxeElement.getParent();
        }
    }

    public void insererDOM(Position position, Node node) {
        JaxeElement jaxeElement = this.doc.rootJE.elementA(position.getOffset());
        if (jaxeElement.debut.getOffset() == position.getOffset() && !(jaxeElement instanceof JESwing)) {
            jaxeElement = jaxeElement.getParent();
        }
        if (jaxeElement instanceof JETexte || jaxeElement instanceof JEStyle) {
            int n = position.getOffset() - jaxeElement.debut.getOffset();
            if (n > 0) {
                JaxeElement jaxeElement2 = jaxeElement.couper(position);
                Node node2 = jaxeElement.noeud.getParentNode();
                node2.insertBefore(node, jaxeElement2.noeud);
            } else {
                Node node3 = jaxeElement.noeud.getParentNode();
                node3.insertBefore(node, jaxeElement.noeud);
            }
        } else {
            JaxeElement jaxeElement3 = jaxeElement.enfantApres(position.getOffset());
            if (jaxeElement3 == null) {
                jaxeElement.noeud.appendChild(node);
            } else {
                jaxeElement.noeud.insertBefore(node, jaxeElement3.noeud);
            }
        }
    }

    public void creerEnfants(Position position) {
        Element element = (Element)this.noeud;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            node = this.creerEnfant(position, node);
        }
    }

    public Node creerEnfant(Position position, Node node) {
        Object object;
        int n = position.getOffset();
        if (node.getNodeType() == 1 || node.getNodeType() == 7 || node.getNodeType() == 8 || node.getNodeType() == 4) {
            Object object2;
            object = null;
            String string = null;
            if (node.getNodeType() == 1) {
                if (this.doc.cfg != null) {
                    object2 = node.getParentNode();
                    object = object2 != null ? this.doc.cfg.getElementRef((Element)node, this.doc.getElementForNode((Node)object2).refElement) : this.doc.cfg.getElementRef((Element)node, null);
                }
                if (object != null) {
                    string = this.doc.cfg.typeAffichageElement((Element)object);
                }
            }
            if (node.getNodeType() == 1 && object == null) {
                object2 = new JEInconnu(this.doc);
                ((JaxeElement)object2).creer(position, node);
            } else if (node.getNodeType() == 7 || node.getNodeType() == 8 || node.getNodeType() == 4 || !"style".equals(string) || this.hasText(node) || this.hasProcessing(node)) {
                Object object3;
                Object object4;
                if (node.getNodeType() == 7) {
                    object2 = "instruction";
                } else if (node.getNodeType() == 8) {
                    object2 = "commentaire";
                } else if (node.getNodeType() == 4) {
                    object2 = "cdata";
                } else if (string.equals("style") && this.hasProcessing(node)) {
                    object4 = node.getPreviousSibling();
                    object3 = node.getParentNode();
                    ProcessingInstruction processingInstruction = this.getProcessing(node);
                    node.getParentNode().replaceChild(processingInstruction, node);
                    node = object4 == null ? object3.getFirstChild() : object4.getNextSibling();
                    object = null;
                    object2 = "instruction";
                } else {
                    object2 = "element";
                }
                object3 = this.doc.getElementForNode(node);
                if (object3 != null) {
                    object4 = object3;
                    ((JaxeElement)object4).debut = null;
                    ((JaxeElement)object4).fin = null;
                    ((JaxeElement)object4).jcomps = new ArrayList();
                    ((JaxeElement)object4).compos = new ArrayList();
                } else {
                    object4 = JEFactory.createJE(this.doc, (Element)object, node.getNodeName(), (String)object2, node);
                }
                ((JaxeElement)object4).creer(position, node);
            }
        } else if (node.getNodeType() == 3) {
            object = new JETexte(this.doc);
            ((JaxeElement)object).creer(position, node);
        }
        try {
            if (this.debut == null) {
                this.debut = this.doc.createPosition(n);
            }
            if (position.getOffset() == 0) {
                position = this.doc.createPosition(1);
            }
            this.fin = this.doc.createPosition(position.getOffset() - 1);
        }
        catch (BadLocationException badLocationException) {
            LOG.error("creerEnfant(Position, Node) - BadLocationException: " + badLocationException.getMessage(), badLocationException);
        }
        return node;
    }

    public void setFocus() {
        this.doc.textPane.requestFocus();
    }

    public Position insPosition() {
        try {
            Position position = this.doc.createPosition(this.fin.getOffset() + 1);
            return position;
        }
        catch (BadLocationException badLocationException) {
            LOG.error("insPosition() - BadLocationException: " + badLocationException.getMessage(), badLocationException);
            return this.debut;
        }
    }

    public boolean hasText(Node node) {
        boolean bl = false;
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            bl = node2.getNodeType() == 3 ? true : this.hasText(node2);
        }
        return bl;
    }

    public boolean hasProcessing(Node node) {
        boolean bl = false;
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            bl = node2.getNodeType() == 7 ? true : this.hasProcessing(node2);
        }
        return bl;
    }

    public ProcessingInstruction getProcessing(Node node) {
        ProcessingInstruction processingInstruction = null;
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            processingInstruction = node2.getNodeType() == 7 ? (ProcessingInstruction)node2 : this.getProcessing(node2);
        }
        return processingInstruction;
    }

    public JaxeElement getParent() {
        Node node = this.noeud.getParentNode();
        if (node == null) {
            return null;
        }
        return this.doc.getElementForNode(node);
    }

    public JaxeElement getFirstChild() {
        Node node = this.noeud.getFirstChild();
        if (node == null) {
            return null;
        }
        return this.doc.getElementForNode(node);
    }

    public JaxeElement getNextSibling() {
        Node node = this.noeud.getNextSibling();
        if (node == null) {
            return null;
        }
        return this.doc.getElementForNode(node);
    }

    public void supprimerEnfant(JaxeElement jaxeElement) {
        this.supprimerEnfantDOM(jaxeElement);
        try {
            int n = jaxeElement.fin.getOffset() - jaxeElement.debut.getOffset() + 1;
            int n2 = jaxeElement.debut.getOffset();
            this.doc.remove(n2, n, false);
        }
        catch (BadLocationException badLocationException) {
            LOG.error("supprimerEnfant() - BadLocationException", badLocationException);
        }
    }

    public void supprimerEnfantDOM(JaxeElement jaxeElement) {
        try {
            this.noeud.removeChild(jaxeElement.noeud);
        }
        catch (DOMException dOMException) {
            LOG.error("supprimerEnfantDOM() - DOMException", dOMException);
        }
    }

    public void remplacerEnfant(JaxeElement jaxeElement, JaxeElement jaxeElement2) {
        try {
            this.doc.remove(jaxeElement.debut.getOffset(), jaxeElement.fin.getOffset() - jaxeElement.debut.getOffset() + 1);
        }
        catch (BadLocationException badLocationException) {
            LOG.error("remplacerEnfant() - BadLocationException", badLocationException);
        }
        jaxeElement2.creer(jaxeElement2.debut, jaxeElement2.noeud);
        this.remplacerEnfantDOM(jaxeElement, jaxeElement2);
    }

    public void remplacerEnfantDOM(JaxeElement jaxeElement, JaxeElement jaxeElement2) {
        Node node = jaxeElement.noeud.getParentNode();
        if (node == null) {
            LOG.error("remplacerEnfantDOM(JaxeElement, JaxeElement) - remplacerEnfantDOM: parent null !", null);
        }
        try {
            node.replaceChild(jaxeElement2.noeud, jaxeElement.noeud);
        }
        catch (DOMException dOMException) {
            LOG.error("remplacerEnfantDOM(JaxeElement, JaxeElement) - DOMException: " + dOMException.getMessage(), dOMException);
        }
    }

    public boolean avecIndentation() {
        return false;
    }

    public boolean avecSautsDeLigne() {
        return false;
    }

    public int indentations() {
        JaxeElement jaxeElement;
        JaxeElement jaxeElement2 = this.getParent();
        if (jaxeElement2 != null && (jaxeElement = jaxeElement2.getParent()) != null && (jaxeElement = jaxeElement.getParent()) instanceof JETableTexte) {
            return 0;
        }
        if (jaxeElement2 == null) {
            return 0;
        }
        if (this.avecIndentation()) {
            return jaxeElement2.indentations() + 1;
        }
        return jaxeElement2.indentations();
    }

    public JaxeElement couper(Position position) {
        String string = this.noeud.getNodeValue();
        String string2 = string.substring(0, position.getOffset() - this.debut.getOffset());
        String string3 = string.substring(position.getOffset() - this.debut.getOffset());
        this.noeud.setNodeValue(string2);
        Text text = this.doc.DOMdoc.createTextNode(string3);
        Node node = this.noeud.getNextSibling();
        JaxeElement jaxeElement = this.getParent();
        if (node == null) {
            jaxeElement.noeud.appendChild(text);
        } else {
            jaxeElement.noeud.insertBefore(text, node);
        }
        JETexte jETexte = new JETexte(this.doc);
        jETexte.noeud = text;
        jETexte.doc = jaxeElement.doc;
        try {
            jETexte.debut = this.doc.createPosition(position.getOffset());
            jETexte.fin = this.fin;
            this.fin = this.doc.createPosition(position.getOffset() - 1);
        }
        catch (BadLocationException badLocationException) {
            LOG.error("couper() - BadLocationException", badLocationException);
        }
        this.doc.dom2JaxeElement.put(jETexte.noeud, jETexte);
        return jETexte;
    }

    public void fusionner(JaxeElement jaxeElement) {
        if (!(this instanceof JETexte) || !(jaxeElement instanceof JETexte)) {
            return;
        }
        if (this.noeud.getNextSibling() == jaxeElement.noeud) {
            String string = jaxeElement.noeud.getNodeValue();
            this.noeud.setNodeValue(this.noeud.getNodeValue() + string);
            this.fin = jaxeElement.fin;
            jaxeElement.getParent().supprimerEnfantDOM(jaxeElement);
        } else if (jaxeElement.noeud.getNextSibling() == this.noeud) {
            String string = jaxeElement.noeud.getNodeValue();
            this.noeud.setNodeValue(string + this.noeud.getNodeValue());
            this.debut = jaxeElement.debut;
            jaxeElement.getParent().supprimerEnfantDOM(jaxeElement);
        }
    }

    public void regrouperTextes() {
        for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            JaxeElement jaxeElement = this.doc.getElementForNode(node);
            JaxeElement jaxeElement2 = this.doc.getElementForNode(node.getNextSibling());
            while (jaxeElement2 != null && (jaxeElement instanceof JETexte && jaxeElement2 instanceof JETexte || jaxeElement instanceof JEStyle && jaxeElement2 instanceof JEStyle && this.sameStyle(jaxeElement, jaxeElement2))) {
                jaxeElement.fusionner(jaxeElement2);
                jaxeElement2 = jaxeElement.getNextSibling();
            }
        }
    }

    public void setEffacementAutorise(boolean bl) {
        this.effacementAutorise = bl;
    }

    public boolean getEffacementAutorise() {
        return this.effacementAutorise;
    }

    public void setEditionAutorisee(boolean bl) {
        this.editionAutorisee = bl;
    }

    public boolean getEditionAutorisee() {
        return this.editionAutorisee;
    }

    public void selection(boolean bl) {
        Object object;
        Object object2 = this.jcomps.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof MonBouton)) continue;
            ((MonBouton)object).selection(bl);
        }
        for (object2 = this.noeud.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            object = this.doc.getElementForNode((Node)object2);
            if (object == null) continue;
            ((JaxeElement)object).selection(bl);
        }
    }

    public boolean sameStyle(JaxeElement jaxeElement, JaxeElement jaxeElement2) {
        if (!(jaxeElement instanceof JEStyle) || !(jaxeElement2 instanceof JEStyle)) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        JEStyle jEStyle = (JEStyle)jaxeElement;
        JEStyle jEStyle2 = (JEStyle)jaxeElement2;
        Iterator<Element> iterator = jEStyle._styles.iterator();
        if (jEStyle2._styles.size() != jEStyle._styles.size()) {
            return false;
        }
        while (iterator.hasNext()) {
            arrayList.add(((Node)iterator.next()).getNodeName());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        iterator = jEStyle2._styles.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(((Node)iterator.next()).getNodeName());
        }
        boolean bl = true;
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext() && bl) {
            if (arrayList2.contains(iterator2.next())) continue;
            bl = false;
        }
        iterator2 = arrayList2.iterator();
        while (iterator2.hasNext() && bl) {
            if (arrayList.contains(iterator2.next())) continue;
            bl = false;
        }
        if (bl) {
            Object[] objectArray = jEStyle.ceStyle.split(";");
            Object[] objectArray2 = jEStyle2.ceStyle.split(";");
            Arrays.sort(objectArray);
            Arrays.sort(objectArray2);
            List<Object> list = Arrays.asList(objectArray);
            List<Object> list2 = Arrays.asList(objectArray2);
            bl = list.containsAll(list2) && list2.containsAll(list);
        }
        return bl;
    }

    public boolean aDesAttributs() {
        if (this.noeud.getNodeType() != 1) {
            return false;
        }
        Element element = (Element)this.noeud;
        if (this.doc.cfg == null) {
            return true;
        }
        if (this.refElement == null) {
            return true;
        }
        ArrayList<Element> arrayList = this.doc.cfg.listeAttributs(this.refElement);
        return arrayList != null && arrayList.size() > 0;
    }

    public Point getPointEnfant(Element element) {
        return null;
    }

    public static void setMonBoutonCouleurs(Color[][] colorArray) {
        couleursButtons = colorArray;
    }

    public static Color[][] getMonBoutonCouleurs() {
        return couleursButtons;
    }

    @Deprecated
    public static void setMonBoutonBorder(Border border) {
        boutonBorder = border;
    }

    public static Border getMonBoutonBorder() {
        return boutonBorder;
    }

    public static Font getMonBoutonFont() {
        return boutonFont;
    }

    public static void setMonBoutonFont(Font font) {
        boutonFont = font;
    }

    protected String getString(String string) {
        return JaxeResourceBundle.getRB().getString(string);
    }

    public void changerStyle(String string, int n, int n2) {
        if (string != null) {
            String[] stringArray = string.split(";");
            Style style = this.doc.textPane.addStyle(null, null);
            for (String string2 : stringArray) {
                if (string2.indexOf(kExposant) > -1) {
                    StyleConstants.setSuperscript(style, true);
                }
                if (string2.indexOf(kIndice) > -1) {
                    StyleConstants.setSubscript(style, true);
                }
                if (string2.indexOf(kCouleur) > -1) {
                    StyleConstants.setForeground(style, this.obtenezCouleur(string2, Color.red));
                }
                if (string2.indexOf(kCouleurDeFond) > -1) {
                    StyleConstants.setBackground(style, this.obtenezCouleur(string2, Color.green));
                }
                if (string2.indexOf(kItalique) > -1) {
                    StyleConstants.setItalic(style, true);
                }
                if (string2.indexOf(kGras) > -1) {
                    StyleConstants.setBold(style, true);
                }
                if (string2.indexOf(kSouligne) > -1) {
                    StyleConstants.setUnderline(style, true);
                }
                if (string2.indexOf(kBarre) > -1) {
                    StyleConstants.setStrikeThrough(style, true);
                }
                if (string2.equals("")) continue;
                this.doc.setCharacterAttributes(n, n2, style, false);
            }
        }
    }

    private Color obtenezCouleur(String string, Color color) {
        Matcher matcher = COLOR_PATTERN.matcher(string);
        if (matcher.matches()) {
            boolean bl = false;
            int[] nArray = new int[3];
            for (int i = 0; i < 3; ++i) {
                String string2 = matcher.group(i + 1);
                try {
                    if (string2.startsWith("x")) {
                        nArray[i] = Integer.parseInt(string2.substring(1), 16);
                        continue;
                    }
                    nArray[i] = Integer.parseInt(string2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    nArray[i] = 0;
                    bl = true;
                }
            }
            Color color2 = new Color(nArray[0], nArray[1], nArray[2]);
            if (!color2.equals(Color.black) || !bl) {
                color = color2;
            }
        }
        return color;
    }

    public SimpleAttributeSet attStyle(SimpleAttributeSet simpleAttributeSet) {
        Object object;
        SimpleAttributeSet simpleAttributeSet2 = simpleAttributeSet;
        JaxeElement jaxeElement = this.noeud.getNodeType() != 1 ? this.getParent() : this;
        Element element = jaxeElement.refElement;
        if (element == null) {
            return simpleAttributeSet2;
        }
        String string = this.doc.cfg.valeurParametreElement(element, "style", null);
        if (this instanceof JEStyle) {
            string = ((JEStyle)this).ceStyle;
        }
        if (string != null) {
            if (simpleAttributeSet2 == null) {
                simpleAttributeSet2 = new SimpleAttributeSet();
            }
            object = string.split(";");
            for (String string2 : object) {
                if (string2.indexOf(kExposant) > -1) {
                    StyleConstants.setSuperscript(simpleAttributeSet2, true);
                }
                if (string2.indexOf(kIndice) > -1) {
                    StyleConstants.setSubscript(simpleAttributeSet2, true);
                }
                if (string2.indexOf(kCouleur) > -1) {
                    StyleConstants.setForeground(simpleAttributeSet2, this.obtenezCouleur(string2, Color.red));
                }
                if (string2.indexOf(kCouleurDeFond) > -1) {
                    StyleConstants.setBackground(simpleAttributeSet2, this.obtenezCouleur(string2, Color.green));
                }
                if (string2.indexOf(kItalique) > -1) {
                    StyleConstants.setItalic(simpleAttributeSet2, true);
                }
                if (string2.indexOf(kGras) > -1) {
                    StyleConstants.setBold(simpleAttributeSet2, true);
                }
                if (string2.indexOf(kSouligne) > -1) {
                    StyleConstants.setUnderline(simpleAttributeSet2, true);
                }
                if (string2.indexOf(kBarre) <= -1) continue;
                StyleConstants.setStrikeThrough(simpleAttributeSet2, true);
            }
        }
        if (!(simpleAttributeSet2 != null && simpleAttributeSet2.isDefined(StyleConstants.FontFamily) || (object = this.doc.cfg.valeurParametreElement(element, "police", null)) == null)) {
            if (simpleAttributeSet2 == null) {
                simpleAttributeSet2 = new SimpleAttributeSet();
            }
            StyleConstants.setFontFamily(simpleAttributeSet2, (String)object);
        }
        if (!(simpleAttributeSet2 != null && simpleAttributeSet2.isDefined(StyleConstants.FontSize) || (object = this.doc.cfg.valeurParametreElement(element, "taille", null)) == null)) {
            try {
                int n = Integer.parseInt((String)object);
                if (simpleAttributeSet2 == null) {
                    simpleAttributeSet2 = new SimpleAttributeSet();
                }
                StyleConstants.setFontSize(simpleAttributeSet2, n);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("attStyle(SimpleAttributeSet) - " + numberFormatException.getClass().getName() + ": " + numberFormatException.getMessage(), numberFormatException);
            }
        }
        if ((object = this.getParent()) != null) {
            return ((JaxeElement)object).attStyle(simpleAttributeSet2);
        }
        return simpleAttributeSet2;
    }

    public String toString() {
        String string = "Element: " + this.getClass().getName();
        string = string + "  noeud: ";
        string = this.noeud == null ? string + "null" : string + this.noeud.getNodeName();
        string = string + "  debut: ";
        string = this.debut == null ? string + "null" : string + this.debut.getOffset();
        string = string + "  fin: ";
        string = this.fin == null ? string + "null" : string + this.fin.getOffset();
        return string;
    }

    public class MonBouton
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        public static final int DEBUT = 0;
        public static final int FIN = 1;
        public static final int VIDE = 2;
        static final int fleche = 7;
        String texte;
        boolean valide = true;
        boolean selectionne = false;
        int noens = 0;
        boolean division;
        boolean attributs;
        int typeBalise;
        int locdepart;
        boolean evtpopup = false;

        @Deprecated
        public MonBouton(String string, boolean bl) {
            this(string, bl, 2);
        }

        public MonBouton(String string, boolean bl, int n) {
            this.division = bl;
            this.texte = string;
            this.typeBalise = n;
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 2));
            if (n == 1) {
                this.add(Box.createRigidArea(new Dimension(8, 0)));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.attributs = JaxeElement.this.aDesAttributs();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            if (this.attributs) {
                this.add(Box.createRigidArea(new Dimension(iconeAttributs.getIconWidth() + 6, 0)));
            }
            this.add(Box.createRigidArea(new Dimension(this.getFontMetrics(boutonFont).stringWidth(string) + 4, 0)));
            if (JaxeElement.this.doc.textPane.iconeValide) {
                this.add(Box.createRigidArea(new Dimension(20, 0)));
            }
            if (bl) {
                this.add(Box.createHorizontalGlue());
            }
            this.setAlignmentY(0.7f);
            if (boutonBorder != null) {
                this.setBorder(boutonBorder);
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 2));
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.evtpopup) {
                return;
            }
            Insets insets = this.getInsets();
            int n = this.typeBalise == 1 ? insets.left + 7 + 1 : insets.left + 1;
            if (this.attributs && mouseEvent.getX() > n && mouseEvent.getX() < n + iconeAttributs.getIconWidth() + 4 && JaxeElement.this.doc.textPane.isEditable() && JaxeElement.this.getEditionAutorisee()) {
                JaxeElement.this.afficherDialogue(JaxeElement.this.doc.textPane.jframe);
            } else if (mouseEvent.getClickCount() == 2) {
                JaxeElement.this.doc.textPane.requestFocus();
                JaxeElement.this.doc.textPane.selectElement((Element)JaxeElement.this.noeud);
            } else {
                int n2 = this.typeBalise == 1 ? JaxeElement.this.fin.getOffset() : JaxeElement.this.debut.getOffset();
                if (mouseEvent.getX() < this.getWidth() / 2) {
                    JaxeElement.this.doc.textPane.setCaretPosition(n2);
                } else {
                    JaxeElement.this.doc.textPane.setCaretPosition(n2 + 1);
                }
                JaxeElement.this.doc.textPane.getCaret().setVisible(true);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popup(mouseEvent);
            } else {
                Point point = mouseEvent.getPoint();
                Point point2 = this.getLocationOnScreen();
                Point point3 = JaxeElement.this.doc.textPane.getLocationOnScreen();
                point.translate(point2.x - point3.x, point2.y - point3.y);
                this.locdepart = JaxeElement.this.doc.textPane.viewToModel(point);
                this.evtpopup = false;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popup(mouseEvent);
            }
        }

        private void popup(MouseEvent mouseEvent) {
            this.evtpopup = true;
            Point point = mouseEvent.getPoint();
            Point point2 = this.getLocationOnScreen();
            Point point3 = JaxeElement.this.doc.textPane.getLocationOnScreen();
            point.translate(point2.x - point3.x, point2.y - point3.y);
            Insets insets = this.getInsets();
            int n = mouseEvent.getX() < insets.left || mouseEvent.getX() > this.getWidth() - insets.right ? JaxeElement.this.doc.textPane.viewToModel(point) : (this.typeBalise == 1 ? JaxeElement.this.fin.getOffset() : JaxeElement.this.debut.getOffset() + 1);
            JaxeElement.this.doc.textPane.menuContextuel(n, point);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Point point2 = this.getLocationOnScreen();
            Point point3 = JaxeElement.this.doc.textPane.getLocationOnScreen();
            point.translate(point2.x - point3.x, point2.y - point3.y);
            int n = JaxeElement.this.doc.textPane.viewToModel(point);
            JaxeElement.this.doc.textPane.setCaretPosition(this.locdepart);
            JaxeElement.this.doc.textPane.moveCaretPosition(n);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void setText(String string) {
            this.texte = string;
            int n = 0;
            if (this.typeBalise == 1) {
                ++n;
            }
            if (this.attributs) {
                ++n;
            }
            this.remove(n);
            this.add(Box.createRigidArea(new Dimension(this.getFontMetrics(boutonFont).stringWidth(string) + 4, 0)), n);
            this.repaint();
        }

        public void setValidite(boolean bl) {
            this.valide = bl;
        }

        public Color getBackground() {
            if (this.selectionne) {
                return couleursButtons[this.noens][1];
            }
            if (this.valide) {
                return couleursButtons[this.noens][0];
            }
            return couleursButtons[this.noens][2];
        }

        public Color getForeground() {
            if (this.selectionne) {
                return couleursButtons[this.noens][0];
            }
            return couleursButtons[this.noens][1];
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            Dimension dimension = new Dimension(8 + insets.left + insets.right, 21);
            if (this.attributs) {
                dimension.width += 20;
            }
            if (this.typeBalise != 2) {
                dimension.width += 7;
            }
            dimension.width += this.getFontMetrics(boutonFont).stringWidth(this.texte);
            if (JaxeElement.this.doc.textPane.iconeValide) {
                dimension.width += 20;
            }
            return dimension;
        }

        public Dimension getMaximumSize() {
            if (this.division) {
                return super.getMaximumSize();
            }
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (this.division) {
                return super.getMinimumSize();
            }
            return this.getPreferredSize();
        }

        public void selection(boolean bl) {
            this.selectionne = bl;
            this.setForeground(this.getForeground());
            this.repaint();
        }

        public void setEnsembleCouleurs(int n) {
            this.noens = n - n / couleursButtons.length * couleursButtons.length;
            this.setForeground(this.getForeground());
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Insets insets = this.getInsets();
            Dimension dimension = this.getSize();
            Polygon polygon = new Polygon();
            if (this.typeBalise == 0) {
                polygon.addPoint(insets.left, insets.top);
                polygon.addPoint(dimension.width - 1 - insets.right - 7, insets.top);
                polygon.addPoint(dimension.width - 1 - insets.right, dimension.height / 2);
                polygon.addPoint(dimension.width - 1 - insets.right - 7, dimension.height - 1 - insets.bottom);
                polygon.addPoint(insets.left, dimension.height - 1 - insets.bottom);
            } else if (this.typeBalise == 1) {
                polygon.addPoint(insets.left + 7, insets.top);
                polygon.addPoint(dimension.width - 1 - insets.right, insets.top);
                polygon.addPoint(dimension.width - 1 - insets.right, dimension.height - 1 - insets.bottom);
                polygon.addPoint(insets.left + 7, dimension.height - 1 - insets.bottom);
                polygon.addPoint(insets.left, dimension.height / 2);
            } else {
                polygon.addPoint(insets.left, insets.top);
                polygon.addPoint(dimension.width - 1 - insets.right, insets.top);
                polygon.addPoint(dimension.width - 1 - insets.right, dimension.height - 1 - insets.bottom);
                polygon.addPoint(insets.left, dimension.height - 1 - insets.bottom);
            }
            graphics.setColor(this.getBackground());
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.lightGray);
            graphics.drawPolygon(polygon);
            graphics.setColor(new Color(100, 100, 100));
            if (this.typeBalise == 0) {
                graphics.drawLine(dimension.width - 1 - insets.right, dimension.height / 2, dimension.width - 1 - insets.right - 7, dimension.height - 1 - insets.bottom);
                graphics.drawLine(dimension.width - 1 - insets.right - 7, dimension.height - 1 - insets.bottom, insets.left, dimension.height - 1 - insets.bottom);
            } else if (this.typeBalise == 1) {
                graphics.drawLine(dimension.width - 1 - insets.right, insets.top, dimension.width - 1 - insets.right, dimension.height - 1 - insets.bottom);
                graphics.drawLine(dimension.width - 1 - insets.right, dimension.height - 1 - insets.bottom, insets.left + 7, dimension.height - 1 - insets.bottom);
                graphics.drawLine(insets.left + 7, dimension.height - 1 - insets.bottom, insets.left, dimension.height / 2);
            } else {
                graphics.drawLine(dimension.width - 1 - insets.right, insets.top, dimension.width - 1 - insets.right, dimension.height - 1 - insets.bottom);
                graphics.drawLine(dimension.width - 1 - insets.right, dimension.height - 1 - insets.bottom, insets.left, dimension.height - 1 - insets.bottom);
            }
            int n = insets.left + 1;
            if (this.typeBalise == 1) {
                n += 8;
            }
            if (this.attributs) {
                graphics.setColor(Color.lightGray);
                graphics.drawRect(n, insets.top + 1, iconeAttributs.getIconWidth() + 1, iconeAttributs.getIconHeight() + 1);
                iconeAttributs.paintIcon(this, graphics, n + 1, insets.top + 2);
                n += iconeAttributs.getIconWidth() + 4;
            }
            n += 2;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            graphics.setColor(this.getForeground());
            Font font = graphics.getFont();
            graphics.setFont(boutonFont);
            FontMetrics fontMetrics = this.getFontMetrics(boutonFont);
            graphics.drawString(this.texte, n, dimension.height - fontMetrics.getDescent() - 2 - insets.bottom);
            graphics.setFont(font);
            if (JaxeElement.this.doc.textPane.iconeValide) {
                ImageIcon imageIcon = this.valide ? iconeValide : iconeInvalide;
                graphics.drawImage(imageIcon.getImage(), n += fontMetrics.stringWidth(this.texte) + 4, 1, null);
            }
        }
    }
}

